/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.authservice;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.eventbus.EventBus;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.graylog.security.authservice.AuthServiceBackend;
import org.graylog.security.authservice.AuthServiceBackendDTO;
import org.graylog.security.events.AuthServiceBackendDeletedEvent;
import org.graylog.security.events.AuthServiceBackendSavedEvent;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedDbService;
import org.graylog2.database.PaginatedList;
import org.graylog2.rest.PaginationParameters;
import org.graylog2.search.SearchQuery;
import org.graylog2.search.SearchQueryParser;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;

public class DBAuthServiceBackendService
extends PaginatedDbService<AuthServiceBackendDTO> {
    private final Map<String, AuthServiceBackend.Factory<? extends AuthServiceBackend>> backendFactories;
    private final EventBus eventBus;
    private static final Set<String> ALLOWED_FIELDS = ImmutableSet.of((Object)"title", (Object)"description");
    private final SearchQueryParser searchQueryParser;

    @Inject
    protected DBAuthServiceBackendService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, Map<String, AuthServiceBackend.Factory<? extends AuthServiceBackend>> backendFactories, EventBus eventBus) {
        super(mongoConnection, mapper, AuthServiceBackendDTO.class, "auth_service_backends");
        this.backendFactories = backendFactories;
        this.eventBus = eventBus;
        this.searchQueryParser = new SearchQueryParser("title", ALLOWED_FIELDS);
    }

    @Override
    public AuthServiceBackendDTO save(AuthServiceBackendDTO newBackend) {
        AuthServiceBackendDTO authServiceBackendDTO = super.save(this.prepareUpdate(newBackend));
        this.eventBus.post((Object)AuthServiceBackendSavedEvent.create(authServiceBackendDTO.id()));
        return authServiceBackendDTO;
    }

    @Override
    public int delete(String id) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)id), (Object)"id cannot be blank");
        int delete = super.delete(id);
        if (delete > 0) {
            this.eventBus.post((Object)AuthServiceBackendDeletedEvent.create(id));
        }
        return delete;
    }

    private AuthServiceBackendDTO prepareUpdate(AuthServiceBackendDTO newBackend) {
        if (newBackend.id() == null) {
            return newBackend;
        }
        AuthServiceBackendDTO existingBackend = (AuthServiceBackendDTO)this.get(newBackend.id()).orElseThrow(() -> new IllegalArgumentException("Couldn't find backend <" + newBackend.id() + ">"));
        return Optional.ofNullable(this.backendFactories.get(existingBackend.config().type())).map(factory -> factory.create(existingBackend)).map(backend -> backend.prepareConfigUpdate(existingBackend, newBackend)).orElseThrow(() -> new IllegalArgumentException("Couldn't find backend implementation for type <" + existingBackend.config().type() + ">"));
    }

    public long countBackends() {
        return this.db.count();
    }

    public PaginatedList<AuthServiceBackendDTO> findPaginated(PaginationParameters params, Predicate<AuthServiceBackendDTO> filter) {
        String sortBy = (String)StringUtils.defaultIfBlank((CharSequence)params.getSortBy(), (CharSequence)"title");
        DBSort.SortBuilder sortBuilder = this.getSortBuilder(params.getOrder(), sortBy);
        DBQuery.Query dbQuery = DBQuery.empty();
        String query = params.getQuery();
        if (!Strings.isNullOrEmpty((String)query)) {
            SearchQuery searchQuery = this.searchQueryParser.parse(query);
            dbQuery = searchQuery.toDBQuery();
        }
        return this.findPaginatedWithQueryFilterAndSort(dbQuery, filter, sortBuilder, params.getPage(), params.getPerPage());
    }
}

