/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bindings.providers;

import javax.inject.Inject;
import javax.inject.Provider;
import org.graylog2.configuration.MongoDbConfiguration;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.MongoConnectionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoConnectionProvider
implements Provider<MongoConnection> {
    private static final Logger LOG = LoggerFactory.getLogger(MongoConnectionProvider.class);
    private static MongoConnection mongoConnection = null;

    @Inject
    public MongoConnectionProvider(MongoDbConfiguration configuration) {
        if (mongoConnection == null) {
            try {
                mongoConnection = new MongoConnectionImpl(configuration);
                mongoConnection.connect();
            }
            catch (Exception e) {
                LOG.error("Error connecting to MongoDB: {}", (Object)e.getMessage());
                throw e;
            }
        }
    }

    public MongoConnection get() {
        return mongoConnection;
    }
}

