/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.commands.journal;

import com.github.rvesse.airline.annotations.Arguments;
import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.restrictions.Required;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.util.List;
import java.util.Map;
import org.graylog2.commands.journal.AbstractJournalCommand;
import org.graylog2.featureflag.FeatureFlags;
import org.graylog2.inputs.codecs.CodecsModule;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.ResolvableInetSocketAddress;
import org.graylog2.plugin.inputs.codecs.Codec;
import org.graylog2.plugin.journal.RawMessage;
import org.graylog2.shared.bindings.ObjectMapperModule;
import org.graylog2.shared.journal.Journal;
import org.slf4j.helpers.MessageFormatter;

@Command(name="decode", description="Decodes messages from the journal")
public class JournalDecode
extends AbstractJournalCommand {
    @Arguments(description="Range of message offsets to decode, e.g. single number 1234567, upper bound ..123456, lower bound 123456..., both 123456..123458")
    @Required
    private String rangeArg;

    public JournalDecode() {
        super("decode-journal");
    }

    @Override
    protected List<Module> getCommandBindings(FeatureFlags featureFlags) {
        return ImmutableList.builder().addAll(super.getCommandBindings(featureFlags)).add((Object)new CodecsModule()).add((Object)new ObjectMapperModule(this.getClass().getClassLoader())).build();
    }

    @Override
    protected void runCommand() {
        Range range;
        block10: {
            try {
                List offsets = Splitter.on((String)"..").limit(2).splitToList((CharSequence)this.rangeArg);
                if (offsets.size() == 1) {
                    range = Range.singleton((Comparable)Long.valueOf((String)offsets.get(0)));
                    break block10;
                }
                if (offsets.size() == 2) {
                    String first = (String)offsets.get(0);
                    String second = (String)offsets.get(1);
                    range = first.isEmpty() ? Range.atMost((Comparable)Long.valueOf(second)) : (second.isEmpty() ? Range.atLeast((Comparable)Long.valueOf(first)) : Range.closed((Comparable)Long.valueOf(first), (Comparable)Long.valueOf(second)));
                    break block10;
                }
                throw new RuntimeException();
            }
            catch (Exception e) {
                System.err.println("Malformed offset range: " + this.rangeArg);
                return;
            }
        }
        Map codecFactory = (Map)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Map<String, Codec.Factory<? extends Codec>>>(){}));
        Long readOffset = (Long)range.lowerEndpoint();
        long count = (Long)range.upperEndpoint() - (Long)range.lowerEndpoint() + 1L;
        List<Journal.JournalReadEntry> entries = this.journal.read(readOffset, count);
        for (Journal.JournalReadEntry entry : entries) {
            RawMessage raw = RawMessage.decode(entry.getPayload(), entry.getOffset());
            if (raw == null) {
                System.err.println(MessageFormatter.format((String)"Journal entry at offset {} failed to decode", (Object)entry.getOffset()));
                continue;
            }
            Codec codec = (Codec)((Codec.Factory)codecFactory.get(raw.getCodecName())).create(raw.getCodecConfig());
            Message message = codec.decode(raw);
            if (message == null) {
                System.err.println(MessageFormatter.format((String)"Could not use codec {} to decode raw message id {} at offset {}", (Object)new Object[]{raw.getCodecName(), raw.getId(), entry.getOffset()}));
            } else {
                message.setMessageQueueId(raw.getMessageQueueId());
                message.setSequenceNr(raw.getSequenceNr());
            }
            ResolvableInetSocketAddress remoteAddress = raw.getRemoteAddress();
            String remote = remoteAddress == null ? "unknown address" : remoteAddress.getInetSocketAddress().toString();
            StringBuffer sb = new StringBuffer();
            sb.append("Message ").append(raw.getId()).append('\n').append(" at ").append(raw.getTimestamp()).append('\n').append(" in format ").append(raw.getCodecName()).append('\n').append(" at offset ").append(raw.getMessageQueueId()).append('\n').append(" seq number ").append(raw.getSequenceNr()).append('\n').append(" received from remote address ").append(remote).append('\n').append(" (source field: ").append(message == null ? "unparsed" : message.getSource()).append(')').append('\n');
            if (message != null) {
                sb.append(" contains ").append(message.getFieldNames().size()).append(" fields.");
            } else {
                sb.append("The message could not be parse by the given codec.");
            }
            System.out.println(sb);
        }
    }
}

