/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database.indices;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.mongojack.JacksonDBCollection;

public class MongoDbIndexTools {
    static final String INDEX_NAME_KEY = "name";
    static final String COLLATION_KEY = "collation";
    static final String UNIQUE_KEY = "unique";
    static final String LOCALE_KEY = "locale";
    private final JacksonDBCollection<?, ObjectId> db;

    public MongoDbIndexTools(JacksonDBCollection<?, ObjectId> db) {
        this.db = db;
    }

    public static void ensureTTLIndex(MongoCollection<Document> collection, Duration ttl, String fieldUpdatedAt) {
        IndexOptions indexOptions = new IndexOptions().expireAfter(Long.valueOf(ttl.getSeconds()), TimeUnit.SECONDS);
        Bson updatedAtKey = Indexes.ascending((String[])new String[]{fieldUpdatedAt});
        for (Document document : collection.listIndexes()) {
            Set keySet = ((Document)document.get((Object)"key", Document.class)).keySet();
            if (!keySet.contains(fieldUpdatedAt)) continue;
            long expireAfterSeconds = ((Number)document.get((Object)"expireAfterSeconds", Number.class)).longValue();
            if (Objects.equals(expireAfterSeconds, indexOptions.getExpireAfter(TimeUnit.SECONDS))) {
                return;
            }
            collection.dropIndex(updatedAtKey);
        }
        collection.createIndex(updatedAtKey, indexOptions);
    }

    public void prepareIndices(String idField, Collection<String> sortFields, Collection<String> caseInsensitiveStringSortFields) {
        if (!sortFields.containsAll(caseInsensitiveStringSortFields)) {
            throw new IllegalArgumentException("Case Insensitive String Sort Fields should be a subset of all Sort Fields ");
        }
        List existingIndices = this.db.getIndexInfo();
        for (String sortField : sortFields) {
            if (sortField.equals(idField)) continue;
            Optional<DBObject> existingIndex = this.getExistingIndex(existingIndices, sortField);
            if (caseInsensitiveStringSortFields.contains(sortField)) {
                if (existingIndex.isEmpty()) {
                    this.createCaseInsensitiveStringIndex(sortField);
                    continue;
                }
                if (existingIndex.get().get(COLLATION_KEY) != null) continue;
                this.dropIndex(sortField);
                this.createCaseInsensitiveStringIndex(sortField);
                continue;
            }
            if (existingIndex.isEmpty()) {
                this.createSingleFieldIndex(sortField);
                continue;
            }
            if (existingIndex.get().get(COLLATION_KEY) == null) continue;
            this.dropIndex(sortField);
            this.createSingleFieldIndex(sortField);
        }
    }

    private void dropIndex(String sortField) {
        this.db.dropIndex((DBObject)new BasicDBObject(sortField, (Object)1));
    }

    private void createSingleFieldIndex(String sortField) {
        this.db.createIndex((DBObject)new BasicDBObject(sortField, (Object)1), (DBObject)new BasicDBObject(UNIQUE_KEY, (Object)false));
    }

    private void createCaseInsensitiveStringIndex(String sortField) {
        this.db.createIndex((DBObject)new BasicDBObject(sortField, (Object)1), (DBObject)new BasicDBObject(COLLATION_KEY, (Object)new BasicDBObject(LOCALE_KEY, (Object)"en")));
    }

    private Optional<DBObject> getExistingIndex(List<DBObject> existingIndices, String sortField) {
        if (existingIndices == null) {
            return Optional.empty();
        }
        return existingIndices.stream().filter(info -> info.get(INDEX_NAME_KEY).equals(sortField + "_1")).findFirst();
    }
}

