/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.grok;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.mongodb.DBCollection;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import io.krakens.grok.api.exception.GrokException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.bson.types.ObjectId;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.grok.GrokPattern;
import org.graylog2.grok.GrokPatternService;
import org.graylog2.grok.GrokPatternServiceImpl;
import org.graylog2.grok.GrokPatternsDeletedEvent;
import org.graylog2.grok.GrokPatternsUpdatedEvent;
import org.graylog2.plugin.database.ValidationException;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MongoDbGrokPatternService
extends GrokPatternServiceImpl {
    public static final String COLLECTION_NAME = "grok_patterns";
    public static final String INDEX_NAME = "idx_name_asc_unique";
    private static final Logger log = LoggerFactory.getLogger(MongoDbGrokPatternService.class);
    public static final int MAX_DISPLAYED_CONFLICTS = 10;
    private final JacksonDBCollection<GrokPattern, ObjectId> dbCollection;
    private final ClusterEventBus clusterBus;

    @Inject
    protected MongoDbGrokPatternService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, ClusterEventBus clusterBus) {
        this.dbCollection = JacksonDBCollection.wrap((DBCollection)mongoConnection.getDatabase().getCollection(COLLECTION_NAME), GrokPattern.class, ObjectId.class, (ObjectMapper)mapper.get());
        this.clusterBus = clusterBus;
        MongoDbGrokPatternService.createIndex(mongoConnection);
    }

    private static void createIndex(MongoConnection mongoConnection) {
        IndexOptions indexOptions = new IndexOptions().name(INDEX_NAME).unique(true);
        mongoConnection.getMongoDatabase().getCollection(COLLECTION_NAME).createIndex(Indexes.ascending((String[])new String[]{"name"}), indexOptions);
    }

    @Override
    public GrokPattern load(String patternId) throws NotFoundException {
        GrokPattern pattern = (GrokPattern)this.dbCollection.findOneById((Object)new ObjectId(patternId));
        if (pattern == null) {
            throw new NotFoundException("Couldn't find Grok pattern with ID " + patternId);
        }
        return pattern;
    }

    @Override
    public Optional<GrokPattern> loadByName(String name) {
        GrokPattern pattern = (GrokPattern)this.dbCollection.findOne(DBQuery.is((String)"name", (Object)name));
        return Optional.ofNullable(pattern);
    }

    @Override
    public Set<GrokPattern> bulkLoad(Collection<String> patternIds) {
        DBCursor dbCursor = this.dbCollection.find(DBQuery.in((String)"_id", patternIds));
        return ImmutableSet.copyOf((Iterator)dbCursor);
    }

    @Override
    public Set<GrokPattern> loadAll() {
        try (DBCursor grokPatterns = this.dbCollection.find();){
            ImmutableSet immutableSet = ImmutableSet.copyOf((Iterator)grokPatterns);
            return immutableSet;
        }
    }

    @Override
    public GrokPattern save(GrokPattern pattern) throws ValidationException {
        try {
            if (!this.validate(pattern)) {
                throw new ValidationException("Invalid pattern " + pattern);
            }
        }
        catch (GrokException | PatternSyntaxException e) {
            throw new ValidationException("Invalid pattern " + pattern + "\n" + e.getMessage());
        }
        if (this.loadByName(pattern.name()).isPresent()) {
            throw new ValidationException("Grok pattern " + pattern.name() + " already exists");
        }
        WriteResult result = this.dbCollection.save((Object)pattern);
        GrokPattern savedGrokPattern = (GrokPattern)result.getSavedObject();
        this.clusterBus.post(GrokPatternsUpdatedEvent.create((Set<String>)ImmutableSet.of((Object)savedGrokPattern.name())));
        return savedGrokPattern;
    }

    @Override
    public GrokPattern update(GrokPattern pattern) throws ValidationException {
        try {
            if (!this.validate(pattern)) {
                throw new ValidationException("Invalid pattern " + pattern);
            }
        }
        catch (GrokException | PatternSyntaxException e) {
            throw new ValidationException("Invalid pattern " + pattern + "\n" + e.getMessage());
        }
        if (pattern.id() == null) {
            throw new ValidationException("Invalid pattern " + pattern);
        }
        WriteResult result = this.dbCollection.update(DBQuery.is((String)"_id", (Object)new ObjectId(pattern.id())), (Object)pattern);
        if (result.isUpdateOfExisting()) {
            this.clusterBus.post(GrokPatternsUpdatedEvent.create((Set<String>)ImmutableSet.of((Object)pattern.name())));
            return pattern;
        }
        throw new ValidationException("Invalid pattern " + pattern);
    }

    @Override
    public List<GrokPattern> saveAll(Collection<GrokPattern> patterns, GrokPatternService.ImportStrategy importStrategy) throws ValidationException {
        Sets.SetView conflictingNames;
        Map newPatternsByName;
        try {
            newPatternsByName = patterns.stream().collect(Collectors.toMap(GrokPattern::name, Function.identity()));
        }
        catch (IllegalStateException e) {
            throw new ValidationException("The supplied Grok patterns contain conflicting names: " + e.getLocalizedMessage());
        }
        Map existingPatternsByName = this.loadAll().stream().collect(Collectors.toMap(GrokPattern::name, Function.identity()));
        if (importStrategy == GrokPatternService.ImportStrategy.ABORT_ON_CONFLICT && !(conflictingNames = Sets.intersection(newPatternsByName.keySet(), existingPatternsByName.keySet())).isEmpty()) {
            Iterable limited = Iterables.limit((Iterable)conflictingNames, (int)10);
            throw new ValidationException("The following Grok patterns already exist: " + StringUtils.join((Iterable)limited, (String)", ") + (String)(conflictingNames.size() > 10 ? " (+ " + (conflictingNames.size() - 10) + " more)" : "") + ".");
        }
        this.validateAllOrThrow(patterns, importStrategy);
        List<GrokPattern> savedPatterns = patterns.stream().map(newPattern -> {
            GrokPattern existingPattern = (GrokPattern)existingPatternsByName.get(newPattern.name());
            if (existingPattern != null) {
                return newPattern.toBuilder().id(existingPattern.id()).build();
            }
            return newPattern;
        }).map(arg_0 -> this.dbCollection.save(arg_0)).map(WriteResult::getSavedObject).collect(Collectors.toList());
        this.clusterBus.post(GrokPatternsUpdatedEvent.create(newPatternsByName.keySet()));
        return savedPatterns;
    }

    @Override
    public int delete(String patternId) {
        GrokPattern grokPattern;
        try {
            grokPattern = this.load(patternId);
        }
        catch (NotFoundException e) {
            log.debug("Couldn't find grok pattern with ID <{}> for deletion", (Object)patternId, (Object)e);
            return 0;
        }
        ObjectId id = new ObjectId(patternId);
        String name = grokPattern.name();
        int deletedPatterns = this.dbCollection.removeById((Object)id).getN();
        this.clusterBus.post(GrokPatternsDeletedEvent.create((Set<String>)ImmutableSet.of((Object)name)));
        return deletedPatterns;
    }

    @Override
    public int deleteAll() {
        Set<GrokPattern> grokPatterns = this.loadAll();
        Set<String> patternNames = grokPatterns.stream().map(GrokPattern::name).collect(Collectors.toSet());
        int deletedPatterns = this.dbCollection.remove(DBQuery.empty()).getN();
        this.clusterBus.post(GrokPatternsDeletedEvent.create(patternNames));
        return deletedPatterns;
    }
}

