/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.indexset;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.configuration.IndexSetsDefaultConfiguration;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.migrations.MaintenanceStrategiesHelper;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.indexer.retention.RetentionStrategyConfig;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexSetConfigFactory {
    private static final Logger LOG = LoggerFactory.getLogger(IndexSetConfigFactory.class);
    private final ElasticsearchConfiguration elasticsearchConfiguration;
    private final MaintenanceStrategiesHelper maintenanceStrategiesHelper;
    private final ClusterConfigService clusterConfigService;

    @Inject
    public IndexSetConfigFactory(ElasticsearchConfiguration elasticsearchConfiguration, MaintenanceStrategiesHelper maintenanceStrategiesHelper, ClusterConfigService clusterConfigService) {
        this.elasticsearchConfiguration = elasticsearchConfiguration;
        this.maintenanceStrategiesHelper = maintenanceStrategiesHelper;
        this.clusterConfigService = clusterConfigService;
    }

    public IndexSetConfig.Builder createDefault() {
        IndexSetsDefaultConfiguration defaultConfig = this.clusterConfigService.get(IndexSetsDefaultConfiguration.class);
        if (defaultConfig == null) {
            LOG.debug("Could not find IndexSetsDefaultConfiguration. Falling back to server configuration values.");
            return this.createInitialFromServerConfig();
        }
        return IndexSetConfig.builder().creationDate(IndexSetConfigFactory.getCreationDate()).indexAnalyzer(defaultConfig.indexAnalyzer()).shards(defaultConfig.shards()).replicas(defaultConfig.replicas()).indexOptimizationDisabled(defaultConfig.indexOptimizationDisabled()).indexOptimizationMaxNumSegments(defaultConfig.indexOptimizationMaxNumSegments()).fieldTypeRefreshInterval(Duration.standardSeconds((long)defaultConfig.fieldTypeRefreshIntervalUnit().toSeconds(defaultConfig.fieldTypeRefreshInterval()))).rotationStrategyClass(defaultConfig.rotationStrategyClass()).rotationStrategy(defaultConfig.rotationStrategyConfig()).retentionStrategyClass(defaultConfig.retentionStrategyClass()).retentionStrategy(defaultConfig.retentionStrategyConfig());
    }

    private IndexSetConfig.Builder createInitialFromServerConfig() {
        ImmutablePair<String, RotationStrategyConfig> rotationConfig = this.maintenanceStrategiesHelper.readRotationConfigFromServerConf();
        ImmutablePair<String, RetentionStrategyConfig> retentionConfig = this.maintenanceStrategiesHelper.readRetentionConfigFromServerConf();
        return IndexSetConfig.builder().creationDate(IndexSetConfigFactory.getCreationDate()).shards(this.elasticsearchConfiguration.getShards()).replicas(this.elasticsearchConfiguration.getReplicas()).rotationStrategyClass((String)rotationConfig.left).rotationStrategy((RotationStrategyConfig)rotationConfig.right).retentionStrategyClass((String)retentionConfig.left).retentionStrategy((RetentionStrategyConfig)retentionConfig.right).indexAnalyzer(this.elasticsearchConfiguration.getAnalyzer()).indexOptimizationMaxNumSegments(this.elasticsearchConfiguration.getIndexOptimizationMaxNumSegments()).indexOptimizationDisabled(this.elasticsearchConfiguration.isDisableIndexOptimization()).fieldTypeRefreshInterval(IndexSetConfig.DEFAULT_FIELD_TYPE_REFRESH_INTERVAL);
    }

    private static ZonedDateTime getCreationDate() {
        return ZonedDateTime.now(ZoneOffset.UTC);
    }
}

