/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.rotation.strategies;

import java.text.MessageFormat;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.graylog2.audit.AuditEventSender;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.indexer.IndexNotFoundException;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.indexer.rotation.strategies.AbstractRotationStrategy;
import org.graylog2.indexer.rotation.strategies.MessageCountRotationStrategyConfig;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;
import org.graylog2.plugin.system.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageCountRotationStrategy
extends AbstractRotationStrategy {
    private static final Logger log = LoggerFactory.getLogger(MessageCountRotationStrategy.class);
    public static final String NAME = "count";

    @Inject
    public MessageCountRotationStrategy(Indices indices, NodeId nodeId, AuditEventSender auditEventSender, ElasticsearchConfiguration elasticsearchConfiguration) {
        super(auditEventSender, nodeId, elasticsearchConfiguration, indices);
    }

    @Override
    public Class<? extends RotationStrategyConfig> configurationClass() {
        return MessageCountRotationStrategyConfig.class;
    }

    @Override
    public RotationStrategyConfig defaultConfiguration() {
        return MessageCountRotationStrategyConfig.createDefault();
    }

    @Override
    @Nullable
    protected AbstractRotationStrategy.Result shouldRotate(String index, IndexSet indexSet) {
        if (!(indexSet.getConfig().rotationStrategy() instanceof MessageCountRotationStrategyConfig)) {
            throw new IllegalStateException("Invalid rotation strategy config <" + indexSet.getConfig().rotationStrategy().getClass().getCanonicalName() + "> for index set <" + indexSet.getConfig().id() + ">");
        }
        MessageCountRotationStrategyConfig config = (MessageCountRotationStrategyConfig)indexSet.getConfig().rotationStrategy();
        try {
            long numberOfMessages = this.indices.numberOfMessages(index);
            boolean shouldRotate = numberOfMessages > (long)config.maxDocsPerIndex();
            MessageFormat format = shouldRotate ? new MessageFormat("Number of messages in <{0}> ({1}) is higher than the limit ({2}). Pointing deflector to new index now!", Locale.ENGLISH) : new MessageFormat("Number of messages in <{0}> ({1}) is lower than the limit ({2}). Not doing anything.", Locale.ENGLISH);
            String message = format.format(new Object[]{index, numberOfMessages, config.maxDocsPerIndex()});
            return this.createResult(shouldRotate, message);
        }
        catch (IndexNotFoundException e) {
            log.error("Unknown index, cannot perform rotation", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getStrategyName() {
        return NAME;
    }
}

