/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.searches;

import java.util.Locale;

public class Sorting {
    public static final Sorting DEFAULT = new Sorting("timestamp", Direction.DESC);
    private final String field;
    private final Direction direction;

    public Sorting(String field, Direction direction) {
        this.field = field;
        this.direction = direction;
    }

    public String getField() {
        return this.field;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public static Sorting fromApiParam(String param) {
        if (param == null || !param.contains(":")) {
            throw new IllegalArgumentException("Invalid sorting parameter: " + param);
        }
        String[] parts = param.split(":");
        return new Sorting(parts[0], Direction.valueOf(parts[1].toUpperCase(Locale.ENGLISH)));
    }

    public static enum Direction {
        ASC,
        DESC;

    }
}

