/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.log4j;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.rolling.FileSize;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.util.Booleans;
import org.graylog2.log4j.MemoryLimitedCompressingFifoRingBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Plugin(name="Memory", category="Core", elementType="appender", printObject=true)
public class MemoryAppender
extends AbstractAppender {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryAppender.class);
    private static final long DEFAULT_BUFFER_SIZE = 0x3200000L;
    private final MemoryLimitedCompressingFifoRingBuffer buffer;

    protected MemoryAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, long bufferSize) {
        super(name, filter, layout, ignoreExceptions, Property.EMPTY_ARRAY);
        this.buffer = new MemoryLimitedCompressingFifoRingBuffer(bufferSize);
    }

    @PluginFactory
    public static MemoryAppender createAppender(@PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="name") String name, @PluginAttribute(value="bufferSize") String bufSizeLegacy, @PluginAttribute(value="bufferSizeBytes", defaultString="50MB") String bufferSizeBytes, @PluginAttribute(value="ignoreExceptions", defaultBoolean=true) String ignore) {
        long bufferSize;
        if (name == null) {
            LOGGER.error("No name provided for MemoryAppender");
            return null;
        }
        if (bufSizeLegacy != null) {
            LOGGER.error("Deprecated log4j.xml setting detected <{}=\"{}\"> Using default <bufferSizeBytes={}> instead", (Object)"bufferSize", (Object)bufSizeLegacy, (Object)bufferSizeBytes);
        }
        long l = bufferSize = bufferSizeBytes == null ? 0x3200000L : FileSize.parse((String)bufferSizeBytes, (long)0x3200000L);
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        boolean ignoreExceptions = Booleans.parseBoolean((String)ignore, (boolean)true);
        return new MemoryAppender(name, filter, (Layout<? extends Serializable>)layout, ignoreExceptions, bufferSize);
    }

    public void append(LogEvent event) {
        try {
            this.buffer.add(this.serializeLogMessage(event.toImmutable()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        super.stop();
        try {
            this.buffer.clear();
        }
        catch (IOException e) {
            LOG.error("Failed to clear in-mem logs buffer", (Throwable)e);
        }
    }

    private byte[] serializeLogMessage(LogEvent log) {
        return this.getLayout().toByteArray(log);
    }

    public void streamFormattedLogMessages(OutputStream outputStream, int limit) {
        this.buffer.streamContent(outputStream, limit);
    }

    public long getLogsSize() {
        return this.buffer.getLogsSize();
    }
}

