/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.indexer.indexset.DefaultIndexSetConfig;
import org.graylog2.indexer.indexset.DefaultIndexSetCreated;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.indexer.indexset.IndexSetConfigFactory;
import org.graylog2.indexer.indexset.IndexSetService;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.indexer.retention.RetentionStrategy;
import org.graylog2.plugin.indexer.rotation.RotationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20161116172100_DefaultIndexSetMigration
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20161116172100_DefaultIndexSetMigration.class);
    private final ElasticsearchConfiguration elasticsearchConfiguration;
    private final Map<String, Provider<RotationStrategy>> rotationStrategies;
    private final Map<String, Provider<RetentionStrategy>> retentionStrategies;
    private final IndexSetService indexSetService;
    private final ClusterConfigService clusterConfigService;
    private final IndexSetConfigFactory indexSetConfigFactory;

    @Inject
    public V20161116172100_DefaultIndexSetMigration(ElasticsearchConfiguration elasticsearchConfiguration, Map<String, Provider<RotationStrategy>> rotationStrategies, Map<String, Provider<RetentionStrategy>> retentionStrategies, IndexSetService indexSetService, ClusterConfigService clusterConfigService, IndexSetConfigFactory indexSetConfigFactory) {
        this.elasticsearchConfiguration = elasticsearchConfiguration;
        this.rotationStrategies = Objects.requireNonNull(rotationStrategies);
        this.retentionStrategies = Objects.requireNonNull(retentionStrategies);
        this.indexSetService = indexSetService;
        this.clusterConfigService = clusterConfigService;
        this.indexSetConfigFactory = indexSetConfigFactory;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2016-11-16T17:21:00Z");
    }

    @Override
    public void upgrade() {
        if (this.clusterConfigService.get(DefaultIndexSetCreated.class) != null) {
            return;
        }
        IndexSetConfig config = this.indexSetConfigFactory.createDefault().title("Default index set").description("The Graylog default index set").isRegular(true).indexPrefix(this.elasticsearchConfiguration.getDefaultIndexPrefix()).indexTemplateName(this.elasticsearchConfiguration.getDefaultIndexTemplateName()).build();
        IndexSetConfig savedConfig = this.indexSetService.save(config);
        this.clusterConfigService.write(DefaultIndexSetConfig.create(savedConfig.id()));
        this.clusterConfigService.write(DefaultIndexSetCreated.create());
        LOG.debug("Successfully created default index set: {}", (Object)savedConfig);
    }
}

