/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import java.time.ZonedDateTime;
import javax.inject.Inject;
import org.graylog2.configuration.IndexSetsDefaultConfiguration;
import org.graylog2.configuration.IndexSetsDefaultConfigurationFactory;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V202211021200_CreateDefaultIndexDefaultsConfig
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V202211021200_CreateDefaultIndexDefaultsConfig.class);
    private final ClusterConfigService clusterConfigService;
    private final IndexSetsDefaultConfigurationFactory factory;

    @Inject
    public V202211021200_CreateDefaultIndexDefaultsConfig(ClusterConfigService clusterConfigService, IndexSetsDefaultConfigurationFactory factory) {
        this.clusterConfigService = clusterConfigService;
        this.factory = factory;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2022-11-02T12:00:00Z");
    }

    @Override
    public void upgrade() {
        if (this.clusterConfigService.get(IndexSetsDefaultConfiguration.class) != null) {
            LOG.debug("Migration already completed.");
            return;
        }
        try {
            this.clusterConfigService.write(this.factory.create());
            LOG.debug("IndexSetsDefaultConfiguration saved.");
        }
        catch (Exception e) {
            LOG.error("Unable to write IndexSetsDefaultConfiguration.", (Throwable)e);
        }
    }
}

