/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import javax.inject.Inject;
import javax.inject.Named;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.periodical.Periodical;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.shared.inputs.InputRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterHealthCheckThread
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterHealthCheckThread.class);
    private NotificationService notificationService;
    private final InputRegistry inputRegistry;
    private final NodeId nodeId;
    private boolean isCloud;

    @Inject
    public ClusterHealthCheckThread(NotificationService notificationService, InputRegistry inputRegistry, NodeId nodeId, @Named(value="is_cloud") boolean isCloud) {
        this.notificationService = notificationService;
        this.inputRegistry = inputRegistry;
        this.nodeId = nodeId;
        this.isCloud = isCloud;
    }

    @Override
    public void doRun() {
        if (this.isCloud) {
            LOG.debug("Skipping run of ClusterHealthCheckThread, since contained checks are not applicable for Cloud.");
            return;
        }
        try {
            if (this.inputRegistry.runningCount() == 0) {
                LOG.debug("No input running in cluster!");
                this.notificationService.publishIfFirst(this.getNotification());
            } else {
                LOG.debug("Running inputs found, disabling notification");
                this.notificationService.fixed(this.getNotification());
            }
        }
        catch (NodeNotFoundException e) {
            LOG.error("Unable to find own node: ", (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    protected Notification getNotification() throws NodeNotFoundException {
        Notification notification = this.notificationService.buildNow();
        notification.addType(Notification.Type.NO_INPUT_RUNNING);
        notification.addSeverity(Notification.Severity.URGENT);
        notification.addNode(this.nodeId.getNodeId());
        return notification;
    }

    @Override
    public boolean runsForever() {
        return false;
    }

    @Override
    public boolean isDaemon() {
        return true;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return true;
    }

    @Override
    public boolean leaderOnly() {
        return true;
    }

    @Override
    public boolean startOnThisNode() {
        return true;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 120;
    }

    @Override
    public int getPeriodSeconds() {
        return 20;
    }
}

