/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.system;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.plugin.system.NodeIdPersistenceException;
import org.graylog2.plugin.system.SimpleNodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class FilePersistedNodeIdProvider
implements Provider<NodeId> {
    private static final Logger LOG = LoggerFactory.getLogger(FilePersistedNodeIdProvider.class);
    private final String filename;

    @Inject
    public FilePersistedNodeIdProvider(@Named(value="node_id_file") String filename) {
        this.filename = filename;
    }

    public NodeId get() {
        return new SimpleNodeId(this.readOrGenerate(this.filename));
    }

    private String readOrGenerate(String filename) {
        try {
            String read = this.read(filename);
            if (read == null || read.isEmpty()) {
                return this.generate(filename);
            }
            LOG.info("Node ID: {}", (Object)read);
            return read;
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            return this.generate(filename);
        }
        catch (Exception e) {
            String msg = "Could not read or generate node ID!";
            LOG.debug("Could not read or generate node ID!", (Throwable)e);
            throw new NodeIdPersistenceException("Could not read or generate node ID!", e);
        }
    }

    private String read(String filename) throws IOException {
        List<String> lines = Files.readAllLines(Paths.get(filename, new String[0]), StandardCharsets.UTF_8);
        return lines.size() > 0 ? lines.get(0) : "";
    }

    private String generate(String filename) throws NodeIdPersistenceException {
        String generated = Tools.generateServerId();
        LOG.info("No node ID file found. Generated: {}", (Object)generated);
        try {
            this.persist(generated, filename);
        }
        catch (IOException e) {
            LOG.debug("Could not persist node ID: ", (Throwable)e);
            throw new NodeIdPersistenceException("Unable to persist node ID", e);
        }
        return generated;
    }

    private void persist(String nodeId, String filename) throws IOException {
        FileUtils.writeStringToFile((File)new File(filename), (String)nodeId, (Charset)StandardCharsets.UTF_8);
    }
}

