/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.cluster;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.cluster.NodeService;
import org.graylog2.rest.RemoteInterfaceProvider;
import org.graylog2.rest.resources.system.RemoteJournalResource;
import org.graylog2.rest.resources.system.responses.JournalSummaryResponse;
import org.graylog2.shared.rest.resources.ProxiedResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="Cluster/Journal", description="Journal information of any nodes in the cluster")
@Path(value="/cluster/{nodeId}/journal")
@Produces(value={"application/json"})
public class ClusterJournalResource
extends ProxiedResource {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterJournalResource.class);

    @Inject
    public ClusterJournalResource(NodeService nodeService, RemoteInterfaceProvider remoteInterfaceProvider, @Context HttpHeaders httpHeaders, @Named(value="proxiedRequestsExecutorService") ExecutorService executorService) throws NodeNotFoundException {
        super(httpHeaders, nodeService, remoteInterfaceProvider, executorService);
    }

    @GET
    @Timed
    @ApiOperation(value="Get message journal information of a given node")
    @RequiresPermissions(value={"journal:read"})
    public JournalSummaryResponse get(@ApiParam(name="nodeId", value="The id of the node to get message journal information.", required=true) @PathParam(value="nodeId") String nodeId) throws IOException, NodeNotFoundException {
        ProxiedResource.NodeResponse response = this.doNodeApiCall(nodeId, RemoteJournalResource.class, RemoteJournalResource::get, Function.identity(), null);
        if (response.isSuccess() && response.entity().isPresent()) {
            return (JournalSummaryResponse)response.entity().get();
        }
        LOG.warn("Unable to get message journal information on node {}: {}", (Object)nodeId, (Object)response.errorText());
        throw new WebApplicationException(response.errorText(), Response.Status.BAD_GATEWAY);
    }
}

