/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest.documentation.generator;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.JsonSchemaGenerator;
import com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.graylog2.shared.ServerVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Generator {
    private static final Logger LOG = LoggerFactory.getLogger(Generator.class);
    public static final String EMULATED_SWAGGER_VERSION = "1.2";
    public static final String CLOUD_VISIBLE = "cloud";
    private static final Map<String, Object> overviewResult = Maps.newHashMap();
    private final Set<Class<?>> resourceClasses;
    private final Map<Class<?>, String> pluginMapping;
    private final String pluginPathPrefix;
    private final ObjectMapper mapper;
    private final boolean isCloud;
    private static final Set<String> PRIMITIVES = ImmutableSet.of((Object)"boolean", (Object)"Boolean", (Object)"Double", (Object)"Float", (Object)"int", (Object)"Integer", (Object[])new String[]{"Long", "long", "Number", "Object", "String", "void", "Void"});

    public Generator(Set<Class<?>> resourceClasses, Map<Class<?>, String> pluginMapping, String pluginPathPrefix, ObjectMapper mapper, boolean isCloud) {
        this.resourceClasses = resourceClasses;
        this.pluginMapping = pluginMapping;
        this.pluginPathPrefix = pluginPathPrefix;
        this.mapper = mapper;
        this.isCloud = isCloud;
    }

    public Generator(Set<Class<?>> resourceClasses, ObjectMapper mapper, boolean isCloud) {
        this(resourceClasses, (Map<Class<?>, String>)ImmutableMap.of(), "", mapper, isCloud);
    }

    private String prefixedPath(Class<?> resourceClass, @Nullable String resourceAnnotationPath) {
        String resourcePath = Strings.nullToEmpty((String)resourceAnnotationPath);
        StringBuilder prefixedPath = new StringBuilder();
        if (this.pluginMapping.containsKey(resourceClass)) {
            prefixedPath.append(this.pluginPathPrefix).append("/").append(this.pluginMapping.get(resourceClass));
        }
        if (!resourcePath.startsWith("/")) {
            prefixedPath.append("/");
        }
        return prefixedPath.append(resourcePath).toString();
    }

    public synchronized Map<String, Object> generateOverview() {
        if (!overviewResult.isEmpty()) {
            return overviewResult;
        }
        ArrayList apis = Lists.newArrayList();
        for (Class<?> clazz : this.getAnnotatedClasses()) {
            Api info = clazz.getAnnotation(Api.class);
            Path path = clazz.getAnnotation(Path.class);
            if (info == null || path == null) {
                LOG.debug("Skipping REST resource with no Api or Path annotation: <{}>", (Object)clazz.getCanonicalName());
                continue;
            }
            String prefixedPath = this.prefixedPath(clazz, path.value());
            if (this.isCloud && Arrays.stream(info.tags()).noneMatch(CLOUD_VISIBLE::equalsIgnoreCase)) {
                LOG.info("Hiding in cloud: {}", (Object)prefixedPath);
                continue;
            }
            HashMap apiDescription = Maps.newHashMap();
            apiDescription.put("name", prefixedPath.startsWith(this.pluginPathPrefix) ? "Plugins/" + info.value() : info.value());
            apiDescription.put("path", prefixedPath);
            apiDescription.put("description", info.description());
            apis.add(apiDescription);
        }
        apis.sort((o1, o2) -> ComparisonChain.start().compare((Comparable)((Object)o1.get("name").toString()), (Comparable)((Object)o2.get("name").toString())).result());
        overviewResult.put("apiVersion", ServerVersion.VERSION.toString());
        overviewResult.put("swaggerVersion", EMULATED_SWAGGER_VERSION);
        overviewResult.put("apis", apis);
        return overviewResult;
    }

    public Set<Class<?>> getAnnotatedClasses() {
        return this.resourceClasses.stream().filter(clazz -> clazz.isAnnotationPresent(Api.class)).collect(Collectors.toSet());
    }

    public Map<String, Object> generateForRoute(String route, String basePath) {
        HashMap result = Maps.newHashMap();
        HashMap models = Maps.newHashMap();
        HashSet modelTypes = Sets.newHashSet();
        ArrayList apis = Lists.newArrayList();
        for (Class<?> clazz : this.getAnnotatedClasses()) {
            Path path = clazz.getAnnotation(Path.class);
            if (path == null) {
                LOG.debug("Skipping REST resource with no Api or Path annotation: <{}>", (Object)clazz.getCanonicalName());
                continue;
            }
            String prefixedPath = this.prefixedPath(clazz, path.value());
            if (!this.cleanRoute(route).equals(this.cleanRoute(prefixedPath))) continue;
            LOG.debug("Found corresponding REST resource class: <{}>", (Object)clazz.getCanonicalName());
            Method[] methods = clazz.getDeclaredMethods();
            if (methods == null || methods.length == 0) {
                LOG.debug("REST resource <{}> has no methods. Skipping.", (Object)clazz.getCanonicalName());
                break;
            }
            for (Method method : methods) {
                List<Parameter> parameters;
                TypeSchema responseType;
                Object methodPath;
                if (!method.isAnnotationPresent(ApiOperation.class)) {
                    LOG.debug("Method <{}> has no ApiOperation annotation. Skipping.", (Object)method.toGenericString());
                    continue;
                }
                ApiOperation apiOperation = method.getAnnotation(ApiOperation.class);
                HashMap api = Maps.newHashMap();
                ArrayList operations = Lists.newArrayList();
                if (method.isAnnotationPresent(Path.class)) {
                    methodPath = this.cleanRoute(method.getAnnotation(Path.class).value());
                    if (clazz.isAnnotationPresent(Path.class)) {
                        String classPath = this.cleanRoute(this.prefixedPath(clazz, clazz.getAnnotation(Path.class).value()));
                        methodPath = classPath + (String)methodPath;
                    }
                } else if (clazz.isAnnotationPresent(Path.class)) {
                    methodPath = this.cleanRoute(this.prefixedPath(clazz, clazz.getAnnotation(Path.class).value()));
                } else {
                    LOG.debug("Method <{}> has no Path annotation. Skipping.", (Object)method.toGenericString());
                    continue;
                }
                Produces produces = null;
                if (clazz.isAnnotationPresent(Produces.class) || method.isAnnotationPresent(Produces.class)) {
                    produces = clazz.getAnnotation(Produces.class);
                    if (method.isAnnotationPresent(Produces.class)) {
                        produces = method.getAnnotation(Produces.class);
                    }
                }
                api.put("path", methodPath);
                HashMap operation = Maps.newHashMap();
                operation.put("method", this.determineHttpMethod(method));
                operation.put("summary", apiOperation.value());
                operation.put("notes", apiOperation.notes());
                operation.put("nickname", Strings.isNullOrEmpty((String)apiOperation.nickname()) ? method.getName() : apiOperation.nickname());
                if (produces != null) {
                    operation.put("produces", produces.value());
                }
                TypeSchema typeSchema = responseType = apiOperation.response().equals(Void.class) ? this.extractResponseType(method) : this.typeSchema(TypeToken.of((Class)apiOperation.response()).getType());
                if (responseType != null) {
                    models.putAll(responseType.models());
                    if (responseType.name() != null && Generator.isObjectSchema(responseType.type())) {
                        operation.put("type", responseType.name());
                        models.put(responseType.name(), responseType.type());
                    } else if (responseType.type() != null) {
                        operation.putAll(responseType.type());
                    } else {
                        operation.put("type", responseType.name());
                    }
                }
                if ((parameters = this.determineParameters(method)) != null && !parameters.isEmpty()) {
                    operation.put("parameters", parameters);
                }
                for (Parameter parameter : parameters) {
                    TypeSchema parameterTypeSchema = parameter.getTypeSchema();
                    if (parameterTypeSchema.name() != null && parameterTypeSchema.type() != null) {
                        models.put(parameterTypeSchema.name(), parameterTypeSchema.type());
                    }
                    models.putAll(parameterTypeSchema.models());
                }
                operation.put("responseMessages", this.determineResponses(method));
                operations.add(operation);
                api.put("operations", operations);
                apis.add(api);
            }
        }
        if (basePath.endsWith("/")) {
            basePath = basePath.substring(0, basePath.length() - 1);
        }
        Collections.sort(apis, (o1, o2) -> ComparisonChain.start().compare((Comparable)((Object)o1.get("path").toString()), (Comparable)((Object)o2.get("path").toString())).result());
        for (Type type : modelTypes) {
            Class<?> typeClass = Generator.classForType(type);
            TypeSchema modelSchema = this.typeSchema(type);
            if (modelSchema.type() != null) {
                models.put(typeClass.getSimpleName(), modelSchema.type());
            }
            models.putAll(modelSchema.models());
        }
        result.put("apis", apis);
        result.put("basePath", basePath);
        result.put("models", models);
        result.put("resourcePath", this.cleanRoute(route));
        result.put("apiVersion", ServerVersion.VERSION.toString());
        result.put("swaggerVersion", EMULATED_SWAGGER_VERSION);
        return result;
    }

    private TypeSchema createTypeSchema(final String name, final Map<String, Object> type, final Map<String, Object> models) {
        return new TypeSchema(){

            @Override
            public String name() {
                return name;
            }

            @Override
            public Map<String, Object> type() {
                return type;
            }

            @Override
            public Map<String, Object> models() {
                return models;
            }
        };
    }

    private TypeSchema createPrimitiveSchema(String name) {
        return this.createTypeSchema(name, null, Collections.emptyMap());
    }

    private TypeSchema extractResponseType(Method method) {
        Type genericReturnType = method.getGenericReturnType();
        return this.typeSchema(genericReturnType);
    }

    private static Class<?> classForType(Type type) {
        return TypeToken.of((Type)type).getRawType();
    }

    private Type[] typeParameters(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return parameterizedType.getActualTypeArguments();
        }
        return new Type[0];
    }

    private TypeSchema typeSchema(Type genericType) {
        Class<Object> returnType = Generator.classForType(genericType);
        if (returnType.isAssignableFrom(Response.class)) {
            return this.createPrimitiveSchema("any");
        }
        if (returnType.isEnum()) {
            return this.createTypeSchema(null, this.schemaForType(genericType), Collections.emptyMap());
        }
        if (returnType.isAssignableFrom(StreamingOutput.class)) {
            return this.createPrimitiveSchema("string");
        }
        if (Generator.isPrimitive(returnType)) {
            return this.createPrimitiveSchema(Generator.mapPrimitives(returnType.getSimpleName()));
        }
        if (returnType.isAssignableFrom(Map.class)) {
            Map<String, Object> modelItemsDefinition;
            String valueName;
            Type valueType = this.typeParameters(genericType)[1];
            HashMap<String, Object> models = new HashMap<String, Object>();
            if (valueType instanceof Class && Generator.isPrimitive((Class)valueType)) {
                valueName = Generator.mapPrimitives(((Class)valueType).getSimpleName());
                modelItemsDefinition = Collections.singletonMap("additional_properties", valueName);
            } else {
                TypeSchema valueSchema = this.typeSchema(valueType);
                if (valueSchema == null) {
                    return null;
                }
                valueName = valueSchema.name();
                models.putAll(valueSchema.models());
                modelItemsDefinition = Collections.singletonMap("additional_properties", Collections.singletonMap("$ref", valueName));
                if (valueSchema.type() != null) {
                    models.put(valueName, valueSchema.type());
                }
                models.putAll(valueSchema.models());
            }
            String modelName = valueName + "Map";
            ImmutableMap model = ImmutableMap.builder().put((Object)"type", (Object)"object").put((Object)"id", (Object)modelName).put((Object)"properties", Collections.emptyMap()).putAll(modelItemsDefinition).build();
            models.put(modelName, model);
            return this.createTypeSchema(modelName, Collections.singletonMap("type", modelName), models);
        }
        if (returnType.isAssignableFrom(Optional.class)) {
            Type valueType = this.typeParameters(genericType)[0];
            return this.typeSchema(valueType);
        }
        if (returnType.isAssignableFrom(List.class) || returnType.isAssignableFrom(Set.class)) {
            Map<String, Object> modelItemsDefinition;
            String valueName;
            Type valueType = this.typeParameters(genericType)[0];
            HashMap<String, Object> models = new HashMap<String, Object>();
            if (valueType instanceof Class && Generator.isPrimitive((Class)valueType)) {
                valueName = Generator.mapPrimitives(((Class)valueType).getSimpleName());
                modelItemsDefinition = Collections.singletonMap("items", valueName);
            } else {
                TypeSchema valueSchema = this.typeSchema(valueType);
                if (valueSchema == null) {
                    return null;
                }
                valueName = valueSchema.name();
                if (valueSchema.type() != null) {
                    models.put(valueName, valueSchema.type());
                }
                models.putAll(valueSchema.models());
                modelItemsDefinition = Collections.singletonMap("items", Collections.singletonMap("$ref", valueName));
            }
            String modelName = valueName + "Array";
            ImmutableMap model = ImmutableMap.builder().put((Object)"type", (Object)"array").put((Object)"id", (Object)modelName).put((Object)"properties", Collections.emptyMap()).putAll(modelItemsDefinition).build();
            models.put(modelName, model);
            return this.createTypeSchema(modelName, Collections.singletonMap("type", modelName), models);
        }
        String modelName = returnType.getSimpleName();
        Map<String, Object> genericTypeSchema = this.schemaForType(genericType);
        if (!this.isObjectOrArray(genericTypeSchema)) {
            return this.createTypeSchema(null, genericTypeSchema, Collections.emptyMap());
        }
        TypeSchema inlineSchema = this.extractInlineModels(genericTypeSchema);
        return this.createTypeSchema(modelName, inlineSchema.type(), inlineSchema.models());
    }

    private TypeSchema extractInlineModels(Map<String, Object> genericTypeSchema) {
        if (Generator.isObjectSchema(genericTypeSchema)) {
            HashMap<String, Object> newGenericTypeSchema = new HashMap<String, Object>(genericTypeSchema);
            HashMap<String, Object> models = new HashMap<String, Object>();
            if (genericTypeSchema.get("properties") instanceof Map) {
                Map properties = (Map)genericTypeSchema.get("properties");
                Map<String, Object> newProperties = properties.entrySet().stream().map(entry -> {
                    Map property = (Map)entry.getValue();
                    TypeSchema propertySchema = this.extractInlineModels(property);
                    models.putAll(propertySchema.models());
                    if (propertySchema.name() == null) {
                        return new AbstractMap.SimpleEntry<String, Map<String, Object>>((String)entry.getKey(), propertySchema.type());
                    }
                    if (propertySchema.type() != null) {
                        models.put(propertySchema.name(), propertySchema.type());
                    }
                    return new AbstractMap.SimpleEntry<String, Map<String, String>>((String)entry.getKey(), Collections.singletonMap("$ref", propertySchema.name()));
                }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                newGenericTypeSchema.put("properties", newProperties);
            }
            if (genericTypeSchema.get("additional_properties") instanceof Map) {
                Map additionalProperties = (Map)genericTypeSchema.get("additional_properties");
                TypeSchema itemsSchema = this.extractInlineModels(additionalProperties);
                models.putAll(itemsSchema.models());
                if (itemsSchema.name() != null) {
                    if (itemsSchema.type() != null) {
                        models.put(itemsSchema.name(), itemsSchema.type());
                    }
                    newGenericTypeSchema.put("additional_properties", Collections.singletonMap("$ref", itemsSchema.name()));
                }
            }
            if (!genericTypeSchema.containsKey("properties")) {
                newGenericTypeSchema.put("properties", Collections.emptyMap());
            }
            String id = this.shortenJsonSchemaURN((String)genericTypeSchema.get("id"));
            return this.createTypeSchema(id, newGenericTypeSchema, models);
        }
        if (Generator.isArraySchema(genericTypeSchema)) {
            HashMap<String, Object> models = new HashMap<String, Object>();
            HashMap<String, Object> newGenericTypeSchema = new HashMap<String, Object>(genericTypeSchema);
            if (genericTypeSchema.get("items") instanceof Map) {
                Map items = (Map)genericTypeSchema.get("items");
                TypeSchema itemsSchema = this.extractInlineModels(items);
                models.putAll(itemsSchema.models());
                if (itemsSchema.name() != null) {
                    if (itemsSchema.type() != null) {
                        models.put(itemsSchema.name(), itemsSchema.type());
                    }
                    newGenericTypeSchema.put("items", Collections.singletonMap("$ref", itemsSchema.name()));
                }
            }
            return this.createTypeSchema(null, newGenericTypeSchema, models);
        }
        return this.createTypeSchema(null, genericTypeSchema, Collections.emptyMap());
    }

    private String shortenJsonSchemaURN(@Nullable String id) {
        if (id == null) {
            return null;
        }
        Splitter splitter = Splitter.on((String)":");
        List segments = splitter.splitToList((CharSequence)id);
        return segments.size() > 0 ? (String)segments.get(segments.size() - 1) : id;
    }

    private static Optional<String> typeOfSchema(@Nullable Map<String, Object> typeSchema) {
        return Optional.ofNullable(typeSchema).map(schema -> Strings.emptyToNull((String)((String)schema.get("type"))));
    }

    private static boolean isArraySchema(Map<String, Object> genericTypeSchema) {
        return Generator.typeOfSchema(genericTypeSchema).map(type -> type.equals("array")).orElse(false);
    }

    private static boolean isObjectSchema(Map<String, Object> genericTypeSchema) {
        return Generator.typeOfSchema(genericTypeSchema).map(type -> type.equals("object")).orElse(false);
    }

    private Map<String, Object> schemaForType(Type valueType) {
        SchemaFactoryWrapper schemaFactoryWrapper = new SchemaFactoryWrapper(){};
        JsonSchemaGenerator schemaGenerator = new JsonSchemaGenerator(this.mapper, schemaFactoryWrapper);
        try {
            JsonSchema schema = schemaGenerator.generateSchema(this.mapper.getTypeFactory().constructType(valueType));
            Map schemaMap = (Map)this.mapper.readValue(this.mapper.writeValueAsBytes((Object)schema), Map.class);
            if (schemaMap.containsKey("additional_properties") && !schemaMap.containsKey("properties")) {
                schemaMap.put("properties", Collections.emptyMap());
            }
            if (schemaMap.equals(Collections.singletonMap("type", "any"))) {
                return ImmutableMap.of((Object)"type", (Object)"object", (Object)"properties", Collections.emptyMap());
            }
            return schemaMap;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isObjectOrArray(Map<String, Object> schemaMap) {
        return Generator.isObjectSchema(schemaMap) || Generator.isArraySchema(schemaMap);
    }

    private List<Parameter> determineParameters(Method method) {
        ArrayList params = Lists.newArrayList();
        int i = 0;
        for (Annotation[] annotations : method.getParameterAnnotations()) {
            Parameter param = new Parameter();
            Parameter.Kind paramKind = Parameter.Kind.BODY;
            for (Annotation annotation : annotations) {
                String annotationValue;
                if (annotation instanceof ApiParam) {
                    ApiParam apiParam = (ApiParam)annotation;
                    String name = Strings.isNullOrEmpty((String)apiParam.name()) ? (Strings.isNullOrEmpty((String)apiParam.value()) ? "arg" + i : apiParam.value()) : apiParam.name();
                    param.setName(name);
                    param.setDescription(apiParam.value());
                    param.setIsRequired(apiParam.required());
                    TypeSchema parameterSchema = this.typeSchema(method.getGenericParameterTypes()[i]);
                    param.setTypeSchema(parameterSchema);
                    if (!Strings.isNullOrEmpty((String)apiParam.defaultValue())) {
                        param.setDefaultValue(apiParam.defaultValue());
                    }
                    if (!Strings.isNullOrEmpty((String)apiParam.allowableValues()) && !apiParam.allowableValues().startsWith("range[")) {
                        List<String> allowableValues = Arrays.asList(apiParam.allowableValues().split(","));
                        param.setAllowableValues(allowableValues);
                    }
                }
                if (annotation instanceof DefaultValue) {
                    DefaultValue defaultValueAnnotation = (DefaultValue)annotation;
                    if (Strings.isNullOrEmpty((String)param.getDefaultValue()) && !Strings.isNullOrEmpty((String)defaultValueAnnotation.value())) {
                        param.setDefaultValue(defaultValueAnnotation.value());
                    }
                }
                if (annotation instanceof QueryParam) {
                    paramKind = Parameter.Kind.QUERY;
                    annotationValue = ((QueryParam)annotation).value();
                    param.setName(annotationValue);
                    continue;
                }
                if (annotation instanceof PathParam) {
                    annotationValue = ((PathParam)annotation).value();
                    if (!Strings.isNullOrEmpty((String)annotationValue)) {
                        param.setName(annotationValue);
                    }
                    paramKind = Parameter.Kind.PATH;
                    continue;
                }
                if (annotation instanceof HeaderParam) {
                    paramKind = Parameter.Kind.HEADER;
                    annotationValue = ((HeaderParam)annotation).value();
                    param.setName(annotationValue);
                    continue;
                }
                if (!(annotation instanceof FormParam)) continue;
                paramKind = Parameter.Kind.FORM;
                annotationValue = ((FormParam)annotation).value();
                param.setName(annotationValue);
            }
            param.setKind(paramKind);
            if (param.getTypeSchema() != null) {
                params.add(param);
            }
            ++i;
        }
        return params;
    }

    private List<Map<String, Object>> determineResponses(Method method) {
        ArrayList result = Lists.newArrayList();
        ApiResponses annotation = method.getAnnotation(ApiResponses.class);
        if (null != annotation) {
            for (ApiResponse response : annotation.value()) {
                ImmutableMap responseDescription = ImmutableMap.of((Object)"code", (Object)response.code(), (Object)"message", (Object)response.message());
                result.add(responseDescription);
            }
        }
        return result;
    }

    private String cleanRoute(String route) {
        if (!((String)route).startsWith("/")) {
            route = "/" + (String)route;
        }
        if (((String)route).endsWith("/")) {
            route = ((String)route).substring(0, ((String)route).length() - 1);
        }
        return route;
    }

    private static boolean isPrimitive(String simpleName) {
        return PRIMITIVES.contains(simpleName);
    }

    private static boolean isPrimitive(Class<?> klass) {
        return Generator.isPrimitive(klass.getSimpleName());
    }

    private static String mapPrimitives(String simpleName) {
        if (Strings.isNullOrEmpty((String)simpleName)) {
            return simpleName;
        }
        switch (simpleName) {
            case "int": 
            case "Integer": 
            case "Long": {
                return "integer";
            }
            case "Number": 
            case "Float": 
            case "Double": {
                return "number";
            }
            case "String": {
                return "string";
            }
            case "boolean": 
            case "Boolean": {
                return "boolean";
            }
            case "Void": 
            case "void": {
                return "void";
            }
            case "Object": {
                return "any";
            }
        }
        return simpleName;
    }

    @Nullable
    private String determineHttpMethod(Method m) {
        if (m.isAnnotationPresent(GET.class)) {
            return "GET";
        }
        if (m.isAnnotationPresent(POST.class)) {
            return "POST";
        }
        if (m.isAnnotationPresent(PUT.class)) {
            return "PUT";
        }
        if (m.isAnnotationPresent(PATCH.class)) {
            return "PATCH";
        }
        if (m.isAnnotationPresent(DELETE.class)) {
            return "DELETE";
        }
        if (m.isAnnotationPresent(HEAD.class)) {
            return "HEAD";
        }
        if (m.isAnnotationPresent(OPTIONS.class)) {
            return "OPTIONS";
        }
        return null;
    }

    static interface TypeSchema {
        public String name();

        public Map<String, Object> type();

        public Map<String, Object> models();
    }

    public static class Parameter {
        private String name;
        private String description;
        private boolean isRequired;
        private TypeSchema typeSchema;
        private Kind kind;
        private String defaultValue;
        private Collection<String> allowableValues;

        public void setName(String name) {
            this.name = name;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setIsRequired(boolean required) {
            this.isRequired = required;
        }

        public void setRequired(boolean required) {
            this.isRequired = required;
        }

        public void setTypeSchema(TypeSchema typeSchema) {
            this.typeSchema = typeSchema;
        }

        public TypeSchema getTypeSchema() {
            return this.typeSchema;
        }

        private String getType() {
            return Generator.mapPrimitives(this.typeSchema.name());
        }

        public void setKind(Kind kind) {
            this.kind = kind;
        }

        private String getKind() {
            return this.kind.toString().toLowerCase(Locale.ENGLISH);
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void setAllowableValues(Collection<String> allowableValues) {
            this.allowableValues = allowableValues;
        }

        @JsonValue
        public Map<String, Object> jsonValue() {
            HashMap<String, Object> result = new HashMap<String, Object>(){
                {
                    this.put("name", name);
                    this.put("description", description);
                    this.put("required", isRequired);
                    this.put("paramType", this.getKind());
                    if (defaultValue != null) {
                        this.put("defaultValue", defaultValue);
                    }
                    if (allowableValues != null) {
                        this.put("enum", allowableValues);
                    }
                    if (typeSchema.type() == null || Generator.isObjectSchema(typeSchema.type())) {
                        this.put("type", typeSchema.name());
                    } else {
                        this.putAll(typeSchema.type());
                    }
                }
            };
            return ImmutableMap.copyOf((Map)result);
        }

        public static enum Kind {
            BODY,
            HEADER,
            PATH,
            QUERY,
            FORM;

        }
    }

    class PrimitiveType
    implements Type {
        private final String type;

        PrimitiveType(String type) {
            this.type = type;
        }

        @Override
        public String getTypeName() {
            return this.type;
        }
    }
}

