/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest.resources.csp;

import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog.security.authservice.DBAuthServiceBackendService;
import org.graylog2.configuration.TelemetryConfiguration;
import org.graylog2.rest.PaginationParameters;
import org.graylog2.shared.rest.resources.csp.CSPService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSPServiceImpl
implements CSPService {
    private static final Logger LOG = LoggerFactory.getLogger(CSPServiceImpl.class);
    private final String telemetryApiHost;
    private final DBAuthServiceBackendService dbService;
    private volatile String connectSrcValue;

    @Inject
    protected CSPServiceImpl(TelemetryConfiguration telemetryConfiguration, DBAuthServiceBackendService dbService) {
        this.telemetryApiHost = telemetryConfiguration.getTelemetryApiHost();
        this.dbService = dbService;
        this.buildConnectSrc();
    }

    @Override
    public void buildConnectSrc() {
        String hostList = this.dbService.findPaginated(new PaginationParameters(), x -> true).stream().map(dto -> dto.config().externalHTTPHosts()).filter(optList -> optList.isPresent()).map(optList -> String.join((CharSequence)" ", (Iterable)optList.get())).collect(Collectors.joining(" "));
        this.connectSrcValue = "'self' " + this.telemetryApiHost + " " + hostList;
        LOG.debug("Updated CSP: {}", (Object)this.connectSrcValue);
    }

    @Override
    public String connectSrcValue() {
        return this.connectSrcValue;
    }
}

