/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.security;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.apache.shiro.authc.HostAuthenticationToken;
import org.graylog2.shared.security.RemoteAddressAuthenticationToken;

public final class SessionIdToken
implements HostAuthenticationToken,
RemoteAddressAuthenticationToken {
    private final String sessionId;
    private final String host;
    private final String remoteAddr;

    public SessionIdToken(String sessionId, String host, String remoteAddr) {
        this.sessionId = sessionId;
        this.host = host;
        this.remoteAddr = remoteAddr;
    }

    public Object getPrincipal() {
        return this.sessionId;
    }

    public Object getCredentials() {
        return null;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getHost() {
        return this.host;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionIdToken that = (SessionIdToken)o;
        return Objects.equals(this.sessionId, that.sessionId) && Objects.equals(this.host, that.host) && Objects.equals(this.remoteAddr, that.remoteAddr);
    }

    public int hashCode() {
        return Objects.hash(this.sessionId, this.host, this.remoteAddr);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("hashcode", this.hashCode()).add("host", (Object)this.host).toString();
    }
}

