/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.security;

import java.lang.reflect.Method;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresGuest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.shared.security.ShiroAuthenticationFilter;
import org.graylog2.shared.security.ShiroAuthorizationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShiroSecurityBinding
implements DynamicFeature {
    private static final Logger LOG = LoggerFactory.getLogger(ShiroSecurityBinding.class);

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        Class resourceClass = resourceInfo.getResourceClass();
        Method resourceMethod = resourceInfo.getResourceMethod();
        if (resourceMethod.isAnnotationPresent(RequiresAuthentication.class) || resourceClass.isAnnotationPresent(RequiresAuthentication.class)) {
            if (resourceMethod.isAnnotationPresent(RequiresGuest.class)) {
                LOG.debug("Resource method {}#{} is marked as unauthenticated, skipping setting filter.");
            } else {
                LOG.debug("Resource method {}#{} requires an authenticated user.", (Object)resourceClass.getCanonicalName(), (Object)resourceMethod.getName());
                context.register((Object)new ShiroAuthenticationFilter());
            }
        }
        if (resourceMethod.isAnnotationPresent(RequiresPermissions.class) || resourceClass.isAnnotationPresent(RequiresPermissions.class)) {
            RequiresPermissions requiresPermissions = resourceClass.getAnnotation(RequiresPermissions.class);
            if (requiresPermissions == null) {
                requiresPermissions = resourceMethod.getAnnotation(RequiresPermissions.class);
            }
            LOG.debug("Resource method {}#{} requires an authorization checks.", (Object)resourceClass.getCanonicalName(), (Object)resourceMethod.getName());
            context.register((Object)new ShiroAuthorizationFilter(requiresPermissions));
        }
    }
}

