/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.system.stats.elasticsearch;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.graylog2.system.stats.elasticsearch.NodeInfo;

final class AutoValue_NodeInfo
extends NodeInfo {
    private final String version;
    private final Object os;
    private final Long jvmMemHeapMaxInBytes;
    private final List<String> roles;

    private AutoValue_NodeInfo(String version, Object os, Long jvmMemHeapMaxInBytes, List<String> roles) {
        this.version = version;
        this.os = os;
        this.jvmMemHeapMaxInBytes = jvmMemHeapMaxInBytes;
        this.roles = roles;
    }

    @Override
    @JsonProperty
    public String version() {
        return this.version;
    }

    @Override
    @JsonProperty
    public Object os() {
        return this.os;
    }

    @Override
    @JsonProperty
    public Long jvmMemHeapMaxInBytes() {
        return this.jvmMemHeapMaxInBytes;
    }

    @Override
    @JsonProperty
    public List<String> roles() {
        return this.roles;
    }

    public String toString() {
        return "NodeInfo{version=" + this.version + ", os=" + this.os + ", jvmMemHeapMaxInBytes=" + this.jvmMemHeapMaxInBytes + ", roles=" + this.roles + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NodeInfo) {
            NodeInfo that = (NodeInfo)o;
            return this.version.equals(that.version()) && this.os.equals(that.os()) && this.jvmMemHeapMaxInBytes.equals(that.jvmMemHeapMaxInBytes()) && this.roles.equals(that.roles());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.version.hashCode();
        h$ *= 1000003;
        h$ ^= this.os.hashCode();
        h$ *= 1000003;
        h$ ^= this.jvmMemHeapMaxInBytes.hashCode();
        h$ *= 1000003;
        return h$ ^= this.roles.hashCode();
    }

    static final class Builder
    extends NodeInfo.Builder {
        private String version;
        private Object os;
        private Long jvmMemHeapMaxInBytes;
        private List<String> roles;

        Builder() {
        }

        @Override
        public NodeInfo.Builder version(String version) {
            if (version == null) {
                throw new NullPointerException("Null version");
            }
            this.version = version;
            return this;
        }

        @Override
        public NodeInfo.Builder os(Object os) {
            if (os == null) {
                throw new NullPointerException("Null os");
            }
            this.os = os;
            return this;
        }

        @Override
        public NodeInfo.Builder jvmMemHeapMaxInBytes(Long jvmMemHeapMaxInBytes) {
            if (jvmMemHeapMaxInBytes == null) {
                throw new NullPointerException("Null jvmMemHeapMaxInBytes");
            }
            this.jvmMemHeapMaxInBytes = jvmMemHeapMaxInBytes;
            return this;
        }

        @Override
        public NodeInfo.Builder roles(List<String> roles) {
            if (roles == null) {
                throw new NullPointerException("Null roles");
            }
            this.roles = roles;
            return this;
        }

        @Override
        public NodeInfo build() {
            Object missing = "";
            if (this.version == null) {
                missing = (String)missing + " version";
            }
            if (this.os == null) {
                missing = (String)missing + " os";
            }
            if (this.jvmMemHeapMaxInBytes == null) {
                missing = (String)missing + " jvmMemHeapMaxInBytes";
            }
            if (this.roles == null) {
                missing = (String)missing + " roles";
            }
            if (!((String)missing).isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + (String)missing);
            }
            return new AutoValue_NodeInfo(this.version, this.os, this.jvmMemHeapMaxInBytes, this.roles);
        }
    }
}

