/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.telemetry.enterprise;

import java.time.ZonedDateTime;
import org.graylog2.telemetry.enterprise.TelemetryLicenseStatus;

final class AutoValue_TelemetryLicenseStatus
extends TelemetryLicenseStatus {
    private final boolean violated;
    private final boolean expired;
    private final boolean valid;
    private final String subject;
    private final ZonedDateTime expirationDate;
    private final long trafficLimit;

    private AutoValue_TelemetryLicenseStatus(boolean violated, boolean expired, boolean valid, String subject, ZonedDateTime expirationDate, long trafficLimit) {
        this.violated = violated;
        this.expired = expired;
        this.valid = valid;
        this.subject = subject;
        this.expirationDate = expirationDate;
        this.trafficLimit = trafficLimit;
    }

    @Override
    public boolean violated() {
        return this.violated;
    }

    @Override
    public boolean expired() {
        return this.expired;
    }

    @Override
    public boolean valid() {
        return this.valid;
    }

    @Override
    public String subject() {
        return this.subject;
    }

    @Override
    public ZonedDateTime expirationDate() {
        return this.expirationDate;
    }

    @Override
    public long trafficLimit() {
        return this.trafficLimit;
    }

    public String toString() {
        return "TelemetryLicenseStatus{violated=" + this.violated + ", expired=" + this.expired + ", valid=" + this.valid + ", subject=" + this.subject + ", expirationDate=" + this.expirationDate + ", trafficLimit=" + this.trafficLimit + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TelemetryLicenseStatus) {
            TelemetryLicenseStatus that = (TelemetryLicenseStatus)o;
            return this.violated == that.violated() && this.expired == that.expired() && this.valid == that.valid() && this.subject.equals(that.subject()) && this.expirationDate.equals(that.expirationDate()) && this.trafficLimit == that.trafficLimit();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.violated ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.expired ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.valid ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.subject.hashCode();
        h$ *= 1000003;
        h$ ^= this.expirationDate.hashCode();
        h$ *= 1000003;
        return h$ ^= (int)(this.trafficLimit >>> 32 ^ this.trafficLimit);
    }

    @Override
    public TelemetryLicenseStatus.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends TelemetryLicenseStatus.Builder {
        private Boolean violated;
        private Boolean expired;
        private Boolean valid;
        private String subject;
        private ZonedDateTime expirationDate;
        private Long trafficLimit;

        Builder() {
        }

        private Builder(TelemetryLicenseStatus source) {
            this.violated = source.violated();
            this.expired = source.expired();
            this.valid = source.valid();
            this.subject = source.subject();
            this.expirationDate = source.expirationDate();
            this.trafficLimit = source.trafficLimit();
        }

        @Override
        public TelemetryLicenseStatus.Builder violated(boolean violated) {
            this.violated = violated;
            return this;
        }

        @Override
        public TelemetryLicenseStatus.Builder expired(boolean expired) {
            this.expired = expired;
            return this;
        }

        @Override
        public TelemetryLicenseStatus.Builder valid(boolean valid) {
            this.valid = valid;
            return this;
        }

        @Override
        public TelemetryLicenseStatus.Builder subject(String subject) {
            if (subject == null) {
                throw new NullPointerException("Null subject");
            }
            this.subject = subject;
            return this;
        }

        @Override
        public TelemetryLicenseStatus.Builder expirationDate(ZonedDateTime expirationDate) {
            if (expirationDate == null) {
                throw new NullPointerException("Null expirationDate");
            }
            this.expirationDate = expirationDate;
            return this;
        }

        @Override
        public TelemetryLicenseStatus.Builder trafficLimit(long trafficLimit) {
            this.trafficLimit = trafficLimit;
            return this;
        }

        @Override
        public TelemetryLicenseStatus build() {
            Object missing = "";
            if (this.violated == null) {
                missing = (String)missing + " violated";
            }
            if (this.expired == null) {
                missing = (String)missing + " expired";
            }
            if (this.valid == null) {
                missing = (String)missing + " valid";
            }
            if (this.subject == null) {
                missing = (String)missing + " subject";
            }
            if (this.expirationDate == null) {
                missing = (String)missing + " expirationDate";
            }
            if (this.trafficLimit == null) {
                missing = (String)missing + " trafficLimit";
            }
            if (!((String)missing).isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + (String)missing);
            }
            return new AutoValue_TelemetryLicenseStatus(this.violated, this.expired, this.valid, this.subject, this.expirationDate, this.trafficLimit);
        }
    }
}

