/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.views;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.Field;
import com.mongodb.client.model.Variable;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.mongojack.DBSort;

public interface ViewUtils<T> {
    public ObjectMapper mapper();

    public MongoCollection<Document> collection();

    public Class<T> type();

    default public T deserialize(Document document) {
        try {
            if (document.containsKey((Object)"_id")) {
                Object id = document.get((Object)"_id");
                document.remove((Object)"_id");
                document.put("id", id);
            }
            String json = this.mapper().writeValueAsString((Object)document);
            return (T)this.mapper().readValue(json, this.type());
        }
        catch (JsonProcessingException jpe) {
            throw new RuntimeException("Could not deserialize view: " + jpe.getMessage(), jpe);
        }
    }

    default public Stream<Document> findViews(SearchUser searchUser, Bson query, DBSort.SortBuilder sort) {
        String user = searchUser.getUser().getId();
        AggregateIterable result = this.collection().aggregate(List.of(Aggregates.match((Bson)query), Aggregates.lookup((String)"favorites", List.of(new Variable("dashboardId", (Object)this.doc("$concat", List.of("grn::::dashboard:", this.doc("$toString", "$_id")))), new Variable("searchId", (Object)this.doc("$concat", List.of("grn::::search:", this.doc("$toString", "$_id")))), new Variable("userId", (Object)user)), List.of(Aggregates.unwind((String)"$items"), Aggregates.match((Bson)this.doc("$expr", this.doc("$and", List.of(this.doc("$or", List.of(this.doc("$eq", List.of("$items", "$$dashboardId")), this.doc("$eq", List.of("$items", "$$searchId")))), this.doc("$eq", List.of("$user_id", "$$userId")))))), Aggregates.project((Bson)this.doc("_id", 1))), (String)"favorites"), Aggregates.set((Field[])new Field[]{new Field("favorite", (Object)this.doc("$gt", List.of(this.doc("$size", "$favorites"), Integer.valueOf(0))))}), Aggregates.unset((String[])new String[]{"favorites"}), Aggregates.sort((Bson)sort))).collation(Collation.builder().locale("en").build());
        return StreamSupport.stream(result.spliterator(), false);
    }

    private Document doc(String key, Object value) {
        return new Document(key, value);
    }
}

