/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.retention.strategies;

import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.graylog.scheduler.clock.JobSchedulerClock;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.indexer.retention.strategies.AbstractIndexRetentionStrategy;
import org.graylog2.indexer.retention.strategies.NoopRetentionStrategyConfig;
import org.graylog2.plugin.indexer.retention.RetentionStrategyConfig;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoopRetentionStrategy
extends AbstractIndexRetentionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(NoopRetentionStrategy.class);
    public static final String NAME = "none";

    @Inject
    public NoopRetentionStrategy(Indices indices, ActivityWriter activityWriter, JobSchedulerClock clock) {
        super(indices, activityWriter, clock);
    }

    @Override
    protected Optional<Integer> getMaxNumberOfIndices(IndexSet indexSet) {
        return Optional.of(Integer.MAX_VALUE);
    }

    @Override
    protected void retain(List<String> indexNames, IndexSet indexSet) {
        LOG.info("Not running any index retention. This is the no-op index rotation strategy.");
    }

    @Override
    public Class<? extends RetentionStrategyConfig> configurationClass() {
        return NoopRetentionStrategyConfig.class;
    }

    @Override
    public RetentionStrategyConfig defaultConfiguration() {
        return NoopRetentionStrategyConfig.createDefault();
    }
}

