/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.processor.aggregation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.graylog.events.processor.aggregation.AggregationConditions;
import org.graylog.events.processor.aggregation.AggregationEventProcessorConfig;
import org.graylog.events.processor.aggregation.AggregationSeries;
import org.graylog.plugins.views.search.Parameter;

final class AutoValue_AggregationEventProcessorConfig
extends AggregationEventProcessorConfig {
    private final String type;
    private final String query;
    private final ImmutableSet<Parameter> queryParameters;
    private final ImmutableSet<String> streams;
    private final List<String> groupBy;
    private final List<AggregationSeries> series;
    private final Optional<AggregationConditions> conditions;
    private final long searchWithinMs;
    private final long executeEveryMs;

    private AutoValue_AggregationEventProcessorConfig(String type, String query, ImmutableSet<Parameter> queryParameters, ImmutableSet<String> streams, List<String> groupBy, List<AggregationSeries> series, Optional<AggregationConditions> conditions, long searchWithinMs, long executeEveryMs) {
        this.type = type;
        this.query = query;
        this.queryParameters = queryParameters;
        this.streams = streams;
        this.groupBy = groupBy;
        this.series = series;
        this.conditions = conditions;
        this.searchWithinMs = searchWithinMs;
        this.executeEveryMs = executeEveryMs;
    }

    @Override
    @JsonProperty(value="type")
    public String type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="query")
    public String query() {
        return this.query;
    }

    @Override
    @JsonProperty(value="query_parameters")
    public ImmutableSet<Parameter> queryParameters() {
        return this.queryParameters;
    }

    @Override
    @JsonProperty(value="streams")
    public ImmutableSet<String> streams() {
        return this.streams;
    }

    @Override
    @JsonProperty(value="group_by")
    public List<String> groupBy() {
        return this.groupBy;
    }

    @Override
    @JsonProperty(value="series")
    public List<AggregationSeries> series() {
        return this.series;
    }

    @Override
    @JsonProperty(value="conditions")
    public Optional<AggregationConditions> conditions() {
        return this.conditions;
    }

    @Override
    @JsonProperty(value="search_within_ms")
    public long searchWithinMs() {
        return this.searchWithinMs;
    }

    @Override
    @JsonProperty(value="execute_every_ms")
    public long executeEveryMs() {
        return this.executeEveryMs;
    }

    public String toString() {
        return "AggregationEventProcessorConfig{type=" + this.type + ", query=" + this.query + ", queryParameters=" + this.queryParameters + ", streams=" + this.streams + ", groupBy=" + this.groupBy + ", series=" + this.series + ", conditions=" + this.conditions + ", searchWithinMs=" + this.searchWithinMs + ", executeEveryMs=" + this.executeEveryMs + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AggregationEventProcessorConfig) {
            AggregationEventProcessorConfig that = (AggregationEventProcessorConfig)o;
            return this.type.equals(that.type()) && this.query.equals(that.query()) && this.queryParameters.equals(that.queryParameters()) && this.streams.equals(that.streams()) && this.groupBy.equals(that.groupBy()) && this.series.equals(that.series()) && this.conditions.equals(that.conditions()) && this.searchWithinMs == that.searchWithinMs() && this.executeEveryMs == that.executeEveryMs();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.type.hashCode();
        h$ *= 1000003;
        h$ ^= this.query.hashCode();
        h$ *= 1000003;
        h$ ^= this.queryParameters.hashCode();
        h$ *= 1000003;
        h$ ^= this.streams.hashCode();
        h$ *= 1000003;
        h$ ^= this.groupBy.hashCode();
        h$ *= 1000003;
        h$ ^= this.series.hashCode();
        h$ *= 1000003;
        h$ ^= this.conditions.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.searchWithinMs >>> 32 ^ this.searchWithinMs);
        h$ *= 1000003;
        return h$ ^= (int)(this.executeEveryMs >>> 32 ^ this.executeEveryMs);
    }

    @Override
    public AggregationEventProcessorConfig.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends AggregationEventProcessorConfig.Builder {
        private String type;
        private String query;
        private ImmutableSet<Parameter> queryParameters;
        private ImmutableSet<String> streams;
        private List<String> groupBy;
        private List<AggregationSeries> series;
        private Optional<AggregationConditions> conditions = Optional.empty();
        private Long searchWithinMs;
        private Long executeEveryMs;

        Builder() {
        }

        private Builder(AggregationEventProcessorConfig source) {
            this.type = source.type();
            this.query = source.query();
            this.queryParameters = source.queryParameters();
            this.streams = source.streams();
            this.groupBy = source.groupBy();
            this.series = source.series();
            this.conditions = source.conditions();
            this.searchWithinMs = source.searchWithinMs();
            this.executeEveryMs = source.executeEveryMs();
        }

        @Override
        public AggregationEventProcessorConfig.Builder type(String type) {
            if (type == null) {
                throw new NullPointerException("Null type");
            }
            this.type = type;
            return this;
        }

        @Override
        public AggregationEventProcessorConfig.Builder query(String query) {
            if (query == null) {
                throw new NullPointerException("Null query");
            }
            this.query = query;
            return this;
        }

        @Override
        public AggregationEventProcessorConfig.Builder queryParameters(Set<Parameter> queryParameters) {
            this.queryParameters = ImmutableSet.copyOf(queryParameters);
            return this;
        }

        @Override
        public AggregationEventProcessorConfig.Builder streams(Set<String> streams) {
            this.streams = ImmutableSet.copyOf(streams);
            return this;
        }

        @Override
        public AggregationEventProcessorConfig.Builder groupBy(List<String> groupBy) {
            if (groupBy == null) {
                throw new NullPointerException("Null groupBy");
            }
            this.groupBy = groupBy;
            return this;
        }

        @Override
        public AggregationEventProcessorConfig.Builder series(List<AggregationSeries> series) {
            if (series == null) {
                throw new NullPointerException("Null series");
            }
            this.series = series;
            return this;
        }

        @Override
        public AggregationEventProcessorConfig.Builder conditions(@Nullable AggregationConditions conditions) {
            this.conditions = Optional.ofNullable(conditions);
            return this;
        }

        @Override
        public AggregationEventProcessorConfig.Builder searchWithinMs(long searchWithinMs) {
            this.searchWithinMs = searchWithinMs;
            return this;
        }

        @Override
        public AggregationEventProcessorConfig.Builder executeEveryMs(long executeEveryMs) {
            this.executeEveryMs = executeEveryMs;
            return this;
        }

        @Override
        public AggregationEventProcessorConfig build() {
            Object missing = "";
            if (this.type == null) {
                missing = (String)missing + " type";
            }
            if (this.query == null) {
                missing = (String)missing + " query";
            }
            if (this.queryParameters == null) {
                missing = (String)missing + " queryParameters";
            }
            if (this.streams == null) {
                missing = (String)missing + " streams";
            }
            if (this.groupBy == null) {
                missing = (String)missing + " groupBy";
            }
            if (this.series == null) {
                missing = (String)missing + " series";
            }
            if (this.searchWithinMs == null) {
                missing = (String)missing + " searchWithinMs";
            }
            if (this.executeEveryMs == null) {
                missing = (String)missing + " executeEveryMs";
            }
            if (!((String)missing).isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + (String)missing);
            }
            return new AutoValue_AggregationEventProcessorConfig(this.type, this.query, this.queryParameters, this.streams, this.groupBy, this.series, this.conditions, this.searchWithinMs, this.executeEveryMs);
        }
    }
}

