/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest.scriptingapi.mapping;

import java.util.function.Function;
import javax.inject.Inject;
import org.graylog.plugins.views.search.rest.scriptingapi.request.Metric;
import org.graylog.plugins.views.search.rest.scriptingapi.request.PercentileConfiguration;
import org.graylog.plugins.views.search.rest.scriptingapi.validation.MetricValidator;
import org.graylog.plugins.views.search.searchtypes.pivot.SeriesSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Average;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Cardinality;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Count;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Latest;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Max;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Min;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Percentile;
import org.graylog.plugins.views.search.searchtypes.pivot.series.StdDev;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Sum;
import org.graylog.plugins.views.search.searchtypes.pivot.series.SumOfSquares;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Variance;

public class MetricToSeriesSpecMapper
implements Function<Metric, SeriesSpec> {
    private final MetricValidator metricValidator;

    @Inject
    public MetricToSeriesSpecMapper(MetricValidator metricValidator) {
        this.metricValidator = metricValidator;
    }

    @Override
    public SeriesSpec apply(Metric metric) {
        this.metricValidator.validate(metric);
        return switch (metric.functionName()) {
            case "avg" -> Average.builder().field(metric.fieldName()).build();
            case "card" -> Cardinality.builder().field(metric.fieldName()).build();
            case "count" -> Count.builder().field(metric.fieldName()).build();
            case "latest" -> Latest.builder().field(metric.fieldName()).build();
            case "max" -> Max.builder().field(metric.fieldName()).build();
            case "min" -> Min.builder().field(metric.fieldName()).build();
            case "percentile" -> Percentile.builder().field(metric.fieldName()).percentile(((PercentileConfiguration)metric.configuration()).percentile()).build();
            case "stddev" -> StdDev.builder().field(metric.fieldName()).build();
            case "sum" -> Sum.builder().field(metric.fieldName()).build();
            case "sumofsquares" -> SumOfSquares.builder().field(metric.fieldName()).build();
            case "variance" -> Variance.builder().field(metric.fieldName()).build();
            default -> Count.builder().field(metric.fieldName()).build();
        };
    }
}

