/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.scheduler;

import com.github.joschi.jadconfig.Parameter;
import com.github.joschi.jadconfig.ValidationException;
import com.github.joschi.jadconfig.Validator;
import com.github.joschi.jadconfig.util.Duration;
import com.github.joschi.jadconfig.validators.PositiveDurationValidator;
import org.graylog2.plugin.PluginConfigBean;

public class JobSchedulerConfiguration
implements PluginConfigBean {
    public static final String LOOP_SLEEP_DURATION = "job_scheduler_loop_sleep_duration";
    public static final String LOCK_EXPIRATION_DURATION = "job_scheduler_lock_expiration_duration";
    @Parameter(value="job_scheduler_loop_sleep_duration", validators={PositiveDurationValidator.class})
    private Duration loopSleepDuration = Duration.seconds((long)1L);
    @Parameter(value="job_scheduler_lock_expiration_duration", validators={Minimum1MinuteValidator.class})
    private Duration lockExpirationDuration = Duration.minutes((long)5L);

    public Duration getLoopSleepDuration() {
        return this.loopSleepDuration;
    }

    public Duration getLockExpirationDuration() {
        return this.lockExpirationDuration;
    }

    public static class Minimum1MinuteValidator
    implements Validator<Duration> {
        public void validate(String name, Duration value) throws ValidationException {
            if (value != null && value.compareTo(Duration.minutes((long)1L)) < 0) {
                throw new ValidationException("Parameter " + name + " should be at least 1 minute (found " + value + ")");
            }
        }
    }
}

