/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.authservice;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.eventbus.EventBus;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.graylog.security.authservice.AuthServiceBackend;
import org.graylog.security.authservice.AuthServiceBackendDTO;
import org.graylog.security.authservice.AutoValue_GlobalAuthServiceConfig_Data;
import org.graylog.security.authservice.DBAuthServiceBackendService;
import org.graylog.security.authservice.InternalAuthServiceBackend;
import org.graylog.security.events.ActiveAuthServiceBackendChangedEvent;
import org.graylog2.plugin.cluster.ClusterConfigService;

public class GlobalAuthServiceConfig {
    private final ClusterConfigService clusterConfigService;
    private final EventBus eventBus;
    private final DBAuthServiceBackendService dbService;
    private final Map<String, AuthServiceBackend.Factory<? extends AuthServiceBackend>> backendFactories;
    private final AuthServiceBackend defaultBackend;

    @Inject
    public GlobalAuthServiceConfig(ClusterConfigService clusterConfigService, EventBus eventBus, DBAuthServiceBackendService dbService, Map<String, AuthServiceBackend.Factory<? extends AuthServiceBackend>> backendFactories, @InternalAuthServiceBackend AuthServiceBackend defaultBackend) {
        this.clusterConfigService = clusterConfigService;
        this.eventBus = eventBus;
        this.dbService = dbService;
        this.backendFactories = backendFactories;
        this.defaultBackend = Objects.requireNonNull(defaultBackend, "defaultBackend cannot be null");
    }

    public AuthServiceBackend getDefaultBackend() {
        return this.defaultBackend;
    }

    public Optional<AuthServiceBackend> getActiveBackend() {
        Data data = this.clusterConfigService.get(Data.class);
        if (data == null) {
            return Optional.empty();
        }
        return data.activeBackend().flatMap(this.dbService::get).flatMap(this::createBackend);
    }

    private Optional<AuthServiceBackend> createBackend(AuthServiceBackendDTO backend) {
        return Optional.ofNullable(this.backendFactories.get(backend.config().type())).map(factory -> factory.create(backend));
    }

    public Optional<AuthServiceBackendDTO> getActiveBackendConfig() {
        Data data = this.clusterConfigService.getOrDefault(Data.class, Data.create(null));
        return data.activeBackend().flatMap(this.dbService::get);
    }

    public Data getConfiguration() {
        return this.clusterConfigService.getOrDefault(Data.class, Data.create(null));
    }

    public Data updateConfiguration(Data updatedData) {
        String currentActiveBackend = this.getConfiguration().activeBackend().orElse(null);
        this.clusterConfigService.write(updatedData);
        updatedData.activeBackend().ifPresent(newActiveBackend -> {
            if (!newActiveBackend.equals(currentActiveBackend)) {
                this.eventBus.post((Object)ActiveAuthServiceBackendChangedEvent.create(newActiveBackend));
            }
        });
        return Objects.requireNonNull(this.clusterConfigService.get(Data.class), "updated configuration cannot be null");
    }

    @AutoValue
    public static abstract class Data {
        @JsonProperty(value="active_backend")
        public abstract Optional<String> activeBackend();

        @JsonCreator
        public static Data create(@JsonProperty(value="active_backend") @Nullable String activeBackend) {
            return new AutoValue_GlobalAuthServiceConfig_Data(Optional.ofNullable(activeBackend));
        }
    }
}

