/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.processor.storage;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog.events.event.EventWithContext;
import org.graylog.events.processor.storage.EventStorageHandler;
import org.graylog.events.processor.storage.EventStorageHandlerCheckResult;
import org.graylog.events.processor.storage.EventStorageHandlerException;

@Singleton
public class EventStorageHandlerEngine {
    private final Map<String, EventStorageHandler.Factory> storageHandlerFactories;

    @Inject
    public EventStorageHandlerEngine(Map<String, EventStorageHandler.Factory> storageHandlerFactories) {
        this.storageHandlerFactories = storageHandlerFactories;
    }

    public void handleEvents(List<EventWithContext> eventsWithContext, ImmutableList<EventStorageHandler.Config> handlerConfigs) throws EventStorageHandlerException {
        for (EventStorageHandler.Config config : handlerConfigs) {
            EventStorageHandler.Factory storageHandlerFactory = this.storageHandlerFactories.get(config.type());
            if (storageHandlerFactory == null) {
                throw new EventStorageHandlerException("Couldn't find storage handler for type <" + config.type() + ">", config);
            }
            try {
                Object storageHandler = storageHandlerFactory.create(config);
                EventStorageHandlerCheckResult checkResult = storageHandler.checkPreconditions();
                if (checkResult.canExecute()) {
                    storageHandler.handleEvents(eventsWithContext);
                    continue;
                }
                throw new EventStorageHandlerException("Precondition for storage handler <" + config.type() + "> failed: " + checkResult.message(), config);
            }
            catch (Exception e) {
                throw new EventStorageHandlerException("Couldn't execute storage handler <" + config.type() + ">", config, e);
            }
        }
    }
}

