/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.threatintel.adapters.spamhaus;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.validation.constraints.Min;
import org.apache.commons.net.util.SubnetUtils;
import org.graylog.plugins.threatintel.PluginConfigService;
import org.graylog.plugins.threatintel.adapters.spamhaus.;
import org.graylog.plugins.threatintel.tools.AdapterDisabledException;
import org.graylog2.lookup.adapters.dsvhttp.HTTPFileRetriever;
import org.graylog2.plugin.lookup.LookupCachePurge;
import org.graylog2.plugin.lookup.LookupDataAdapter;
import org.graylog2.plugin.lookup.LookupDataAdapterConfiguration;
import org.graylog2.plugin.lookup.LookupResult;
import org.graylog2.shared.utilities.ExceptionUtils;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpamhausEDROPDataAdapter
extends LookupDataAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(SpamhausEDROPDataAdapter.class);
    public static final String NAME = "spamhaus-edrop";
    private static final String[] lists = new String[]{"https://www.spamhaus.org/drop/drop.txt", "https://www.spamhaus.org/drop/edrop.txt"};
    private static final Duration REFRESH_INTERVAL = Duration.standardHours((long)4L);
    private final AtomicReference<Map<String, Map<SubnetUtils.SubnetInfo, String>>> subnets = new AtomicReference(Collections.emptyMap());
    private final HTTPFileRetriever httpFileRetriever;
    private final PluginConfigService pluginConfigService;

    @Inject
    public SpamhausEDROPDataAdapter(@Assisted(value="id") String id, @Assisted(value="name") String name, @Assisted LookupDataAdapterConfiguration config, MetricRegistry metricRegistry, HTTPFileRetriever httpFileRetriever, PluginConfigService pluginConfigService) {
        super(id, name, config, metricRegistry);
        this.httpFileRetriever = httpFileRetriever;
        this.pluginConfigService = pluginConfigService;
    }

    @Override
    public void doStart() throws Exception {
        if (!this.pluginConfigService.config().getCurrent().spamhausEnabled()) {
            throw new AdapterDisabledException("Spamhaus service is disabled, not starting (E)DROP adapter. To enable it please go to System / Configurations.");
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String list : lists) {
            Map<SubnetUtils.SubnetInfo, String> subnetMap = this.fetchSubnetsFromEDROPLists(list);
            if (subnetMap == null) continue;
            builder.put((Object)list, subnetMap);
        }
        this.subnets.set((Map<String, Map<SubnetUtils.SubnetInfo, String>>)builder.build());
    }

    @Override
    protected void doStop() throws Exception {
    }

    @Override
    public Duration refreshInterval() {
        if (!this.pluginConfigService.config().getCurrent().spamhausEnabled()) {
            return Duration.ZERO;
        }
        return Duration.standardSeconds((long)((Config)this.getConfig()).refreshInterval());
    }

    @Override
    protected void doRefresh(LookupCachePurge cachePurge) throws Exception {
        if (!this.pluginConfigService.config().getCurrent().spamhausEnabled()) {
            throw new AdapterDisabledException("Spamhaus service is disabled, not refreshing (E)DROP adapter. To enable it please go to System / Configurations.");
        }
        HashMap<String, Map<SubnetUtils.SubnetInfo, String>> result = new HashMap<String, Map<SubnetUtils.SubnetInfo, String>>(this.subnets.get());
        boolean hasUpdates = false;
        for (String list : lists) {
            Map<SubnetUtils.SubnetInfo, String> newList = this.fetchSubnetsFromEDROPLists(list);
            if (newList == null) continue;
            result.put(list, newList);
            hasUpdates = true;
        }
        if (!hasUpdates) {
            return;
        }
        this.subnets.set((Map<String, Map<SubnetUtils.SubnetInfo, String>>)ImmutableMap.copyOf(result));
        cachePurge.purgeAll();
    }

    private Map<SubnetUtils.SubnetInfo, String> fetchSubnetsFromEDROPLists(String list) {
        ImmutableMap.Builder builder;
        block9: {
            builder = ImmutableMap.builder();
            try {
                Optional<String> body = this.httpFileRetriever.fetchFileIfNotModified(list);
                if (body.isPresent()) {
                    try (Scanner scanner = new Scanner(body.get());){
                        while (scanner.hasNextLine()) {
                            String line = scanner.nextLine().trim();
                            if (line.isEmpty() || line.startsWith(";") || !line.contains(";")) continue;
                            String[] parts = line.split(";");
                            SubnetUtils su = new SubnetUtils(parts[0].trim());
                            builder.put((Object)su.getInfo(), (Object)(parts.length > 1 ? parts[1].trim() : "N/A"));
                        }
                        break block9;
                    }
                }
                return null;
            }
            catch (IOException e) {
                LOG.error("Unable to retrieve Spamhaus (E)DROP list <" + list + ">: ", (Throwable)e);
                return null;
            }
        }
        return builder.build();
    }

    @Override
    public LookupResult doGet(Object key) {
        Optional<Map.Entry> match;
        String ip = String.valueOf(key);
        if (this.subnets.get().isEmpty()) {
            return LookupResult.empty();
        }
        try {
            match = this.subnets.get().values().stream().flatMap(list -> list.entrySet().stream()).filter(entry -> ((SubnetUtils.SubnetInfo)entry.getKey()).isInRange(ip)).findFirst();
        }
        catch (IllegalArgumentException e) {
            LOG.debug("[{}] is an invalid IP address. Lookup aborted. {}", (Object)ip, (Object)ExceptionUtils.getRootCauseMessage(e));
            return LookupResult.empty();
        }
        return match.map(entry -> LookupResult.multi(true, (Map<Object, Object>)ImmutableMap.of((Object)"sbl_id", entry.getValue(), (Object)"subnet", (Object)((SubnetUtils.SubnetInfo)entry.getKey()).getCidrSignature()))).orElse(LookupResult.single(false));
    }

    @Override
    public void set(Object key, Object value) {
    }

    @JsonAutoDetect
    @JsonDeserialize(builder=.AutoValue_SpamhausEDROPDataAdapter_Config.Builder.class)
    @JsonTypeName(value="spamhaus-edrop")
    @AutoValue
    public static abstract class Config
    implements LookupDataAdapterConfiguration {
        @Override
        @JsonProperty(value="type")
        public abstract String type();

        @JsonProperty(value="refresh_interval")
        @Min(value=3600L)
        public abstract @Min(value=3600L) long refreshInterval();

        public static Builder builder() {
            return new .AutoValue_SpamhausEDROPDataAdapter_Config.Builder();
        }

        @Override
        public Optional<Multimap<String, String>> validate() {
            ArrayListMultimap errors = ArrayListMultimap.create();
            return errors.isEmpty() ? Optional.empty() : Optional.of(errors);
        }

        @AutoValue.Builder
        public static abstract class Builder {
            @JsonProperty(value="type")
            public abstract Builder type(String var1);

            @JsonProperty(value="refresh_interval")
            public abstract Builder refreshInterval(long var1);

            public abstract Config build();
        }
    }

    public static class Descriptor
    extends LookupDataAdapter.Descriptor<Config> {
        public Descriptor() {
            super(SpamhausEDROPDataAdapter.NAME, Config.class);
        }

        @Override
        public Config defaultConfiguration() {
            return Config.builder().type(SpamhausEDROPDataAdapter.NAME).refreshInterval(REFRESH_INTERVAL.toStandardSeconds().getSeconds()).build();
        }
    }

    public static interface Factory
    extends LookupDataAdapter.Factory<SpamhausEDROPDataAdapter> {
        @Override
        public SpamhausEDROPDataAdapter create(@Assisted(value="id") String var1, @Assisted(value="name") String var2, LookupDataAdapterConfiguration var3);

        @Override
        public Descriptor getDescriptor();
    }
}

