/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.threatintel.functions.global;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.threatintel.ThreatIntelPluginConfiguration;
import org.graylog.plugins.threatintel.functions.GenericLookupResult;
import org.graylog.plugins.threatintel.functions.global.GlobalLookupResult;
import org.graylog.plugins.threatintel.functions.misc.LookupTableFunction;
import org.graylog2.cluster.ClusterConfigChangedEvent;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.shared.utilities.AutoValueUtils;

abstract class AbstractGlobalLookupFunction
extends AbstractFunction<GlobalLookupResult> {
    private final AtomicReference<java.util.function.Supplier<ThreatIntelPluginConfiguration>> config;
    private final ClusterConfigService clusterConfigService;

    AbstractGlobalLookupFunction(ClusterConfigService clusterConfigService, EventBus serverEventBus) {
        this.clusterConfigService = clusterConfigService;
        serverEventBus.register((Object)this);
        this.config = new AtomicReference<Supplier>(Suppliers.memoize(() -> this.clusterConfigService.getOrDefault(ThreatIntelPluginConfiguration.class, ThreatIntelPluginConfiguration.defaults())));
    }

    GlobalLookupResult matchEntityAgainstFunctions(Map<String, LookupTableFunction<? extends GenericLookupResult>> functions, FunctionArgs args, EvaluationContext context, String prefix) {
        List<String> matches = functions.entrySet().stream().filter(f -> this.isEnabled((LookupTableFunction)f.getValue())).map(entry -> {
            GenericLookupResult result = (GenericLookupResult)((Object)((Object)((LookupTableFunction)entry.getValue()).evaluate(args, context)));
            return result.isMatch() ? (String)entry.getKey() : null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return GlobalLookupResult.fromMatches(matches, prefix.trim());
    }

    abstract boolean isEnabled(LookupTableFunction<? extends GenericLookupResult> var1);

    ThreatIntelPluginConfiguration threatIntelPluginConfiguration() {
        return this.config.get().get();
    }

    @Subscribe
    public void handleUpdatedClusterConfig(ClusterConfigChangedEvent clusterConfigChangedEvent) {
        if (clusterConfigChangedEvent.type().equals(AutoValueUtils.getCanonicalName(ThreatIntelPluginConfiguration.class))) {
            this.config.set((java.util.function.Supplier<ThreatIntelPluginConfiguration>)Suppliers.memoize(() -> this.clusterConfigService.getOrDefault(ThreatIntelPluginConfiguration.class, ThreatIntelPluginConfiguration.defaults())));
        }
    }
}

