/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.threatintel.functions.otx;

import javax.inject.Inject;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.threatintel.functions.otx.AbstractOTXLookupFunction;
import org.graylog.plugins.threatintel.functions.otx.OTXLookupResult;
import org.graylog.plugins.threatintel.tools.Domain;
import org.graylog2.lookup.LookupTableService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OTXDomainLookupFunction
extends AbstractOTXLookupFunction {
    private static final Logger LOG = LoggerFactory.getLogger(OTXDomainLookupFunction.class);
    public static final String NAME = "otx_lookup_domain";
    private static final String VALUE = "domain_name";
    private final ParameterDescriptor<String, String> valueParam = ParameterDescriptor.string("domain_name").description("The domain to look up. Example: foo.example.org (A trailing dot ('.') will be ignored.)").build();

    @Inject
    public OTXDomainLookupFunction(LookupTableService lookupTableService) {
        super(lookupTableService);
    }

    @Override
    public OTXLookupResult evaluate(FunctionArgs args, EvaluationContext context) {
        String domain = this.valueParam.required(args, context);
        if (domain == null) {
            LOG.error("NULL parameter passed to OTX threat intel lookup.");
            return OTXLookupResult.EMPTY;
        }
        LOG.debug("Running OTX lookup for domain [{}].", (Object)domain);
        OTXLookupResult result = this.lookupDomain(Domain.prepareDomain(domain).trim());
        if (result.hasError()) {
            throw new RuntimeException((String)result.getResults().get("message"));
        }
        return result;
    }

    @Override
    public FunctionDescriptor<OTXLookupResult> descriptor() {
        return FunctionDescriptor.builder().name(NAME).description("Look up AlienVault OTX threat intelligence data for a domain name.").params(this.valueParam).returnType(OTXLookupResult.class).build();
    }
}

