/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.GlobalOverride;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.engine.BackendQuery;
import org.graylog.plugins.views.search.searchfilters.model.UsedSearchFilter;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

final class AutoValue_Query
extends Query {
    private final String id;
    private final TimeRange timerange;
    private final Filter filter;
    private final List<UsedSearchFilter> filters;
    private final BackendQuery query;
    private final Optional<GlobalOverride> globalOverride;
    private final ImmutableSet<SearchType> searchTypes;

    private AutoValue_Query(@Nullable String id, TimeRange timerange, @Nullable Filter filter, List<UsedSearchFilter> filters, BackendQuery query, Optional<GlobalOverride> globalOverride, ImmutableSet<SearchType> searchTypes) {
        this.id = id;
        this.timerange = timerange;
        this.filter = filter;
        this.filters = filters;
        this.query = query;
        this.globalOverride = globalOverride;
        this.searchTypes = searchTypes;
    }

    @Override
    @Nullable
    @JsonProperty
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty
    public TimeRange timerange() {
        return this.timerange;
    }

    @Override
    @Nullable
    @JsonProperty
    public Filter filter() {
        return this.filter;
    }

    @Override
    @JsonProperty
    public List<UsedSearchFilter> filters() {
        return this.filters;
    }

    @Override
    @Nonnull
    @JsonProperty
    public BackendQuery query() {
        return this.query;
    }

    @Override
    @JsonIgnore
    public Optional<GlobalOverride> globalOverride() {
        return this.globalOverride;
    }

    @Override
    @Nonnull
    @JsonProperty(value="search_types")
    public ImmutableSet<SearchType> searchTypes() {
        return this.searchTypes;
    }

    public String toString() {
        return "Query{id=" + this.id + ", timerange=" + this.timerange + ", filter=" + this.filter + ", filters=" + this.filters + ", query=" + this.query + ", globalOverride=" + this.globalOverride + ", searchTypes=" + this.searchTypes + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Query) {
            Query that = (Query)o;
            return (this.id == null ? that.id() == null : this.id.equals(that.id())) && this.timerange.equals(that.timerange()) && (this.filter == null ? that.filter() == null : this.filter.equals(that.filter())) && this.filters.equals(that.filters()) && this.query.equals(that.query()) && this.globalOverride.equals(that.globalOverride()) && this.searchTypes.equals(that.searchTypes());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.id == null ? 0 : this.id.hashCode();
        h$ *= 1000003;
        h$ ^= this.timerange.hashCode();
        h$ *= 1000003;
        h$ ^= this.filter == null ? 0 : this.filter.hashCode();
        h$ *= 1000003;
        h$ ^= this.filters.hashCode();
        h$ *= 1000003;
        h$ ^= this.query.hashCode();
        h$ *= 1000003;
        h$ ^= this.globalOverride.hashCode();
        h$ *= 1000003;
        return h$ ^= this.searchTypes.hashCode();
    }

    @Override
    public Query.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends Query.Builder {
        private String id;
        private TimeRange timerange;
        private Filter filter;
        private List<UsedSearchFilter> filters;
        private BackendQuery query;
        private Optional<GlobalOverride> globalOverride = Optional.empty();
        private ImmutableSet<SearchType> searchTypes;

        Builder() {
        }

        private Builder(Query source) {
            this.id = source.id();
            this.timerange = source.timerange();
            this.filter = source.filter();
            this.filters = source.filters();
            this.query = source.query();
            this.globalOverride = source.globalOverride();
            this.searchTypes = source.searchTypes();
        }

        @Override
        public Query.Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        @Nullable
        public String id() {
            return this.id;
        }

        @Override
        public Query.Builder timerange(TimeRange timerange) {
            if (timerange == null) {
                throw new NullPointerException("Null timerange");
            }
            this.timerange = timerange;
            return this;
        }

        @Override
        public Query.Builder filter(Filter filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public Query.Builder filters(List<UsedSearchFilter> filters) {
            if (filters == null) {
                throw new NullPointerException("Null filters");
            }
            this.filters = filters;
            return this;
        }

        @Override
        public Query.Builder query(BackendQuery query) {
            if (query == null) {
                throw new NullPointerException("Null query");
            }
            this.query = query;
            return this;
        }

        @Override
        public Query.Builder globalOverride(@Nullable GlobalOverride globalOverride) {
            this.globalOverride = Optional.ofNullable(globalOverride);
            return this;
        }

        @Override
        public Query.Builder searchTypes(@Nullable Set<SearchType> searchTypes) {
            this.searchTypes = ImmutableSet.copyOf(searchTypes);
            return this;
        }

        @Override
        Query autoBuild() {
            Object missing = "";
            if (this.timerange == null) {
                missing = (String)missing + " timerange";
            }
            if (this.filters == null) {
                missing = (String)missing + " filters";
            }
            if (this.query == null) {
                missing = (String)missing + " query";
            }
            if (this.searchTypes == null) {
                missing = (String)missing + " searchTypes";
            }
            if (!((String)missing).isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + (String)missing);
            }
            return new AutoValue_Query(this.id, this.timerange, this.filter, this.filters, this.query, this.globalOverride, this.searchTypes);
        }
    }
}

