/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.db;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.graylog.plugins.views.search.db.SearchDbService;
import org.graylog.plugins.views.search.views.ViewResolver;
import org.graylog.plugins.views.search.views.ViewSummaryDTO;
import org.graylog.plugins.views.search.views.ViewSummaryService;
import org.graylog2.plugin.periodical.Periodical;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchesCleanUpJob
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(SearchesCleanUpJob.class);
    private final ViewSummaryService viewSummaryService;
    private final SearchDbService searchDbService;
    private final Instant mustNotBeOlderThan;
    private final Map<String, ViewResolver> viewResolvers;

    @Inject
    public SearchesCleanUpJob(ViewSummaryService viewSummaryService, SearchDbService searchDbService, @Named(value="views_maximum_search_age") Duration maximumSearchAge, Map<String, ViewResolver> viewResolvers) {
        this.viewSummaryService = viewSummaryService;
        this.searchDbService = searchDbService;
        this.mustNotBeOlderThan = Instant.now().minus((ReadableDuration)maximumSearchAge);
        this.viewResolvers = viewResolvers;
    }

    @Override
    public boolean runsForever() {
        return false;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return true;
    }

    @Override
    public boolean leaderOnly() {
        return true;
    }

    @Override
    public boolean startOnThisNode() {
        return true;
    }

    @Override
    public boolean isDaemon() {
        return false;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 3600;
    }

    @Override
    public int getPeriodSeconds() {
        return Duration.standardHours((long)8L).toStandardSeconds().getSeconds();
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void doRun() {
        this.searchDbService.getExpiredSearches(this.findReferencedSearchIds(), this.mustNotBeOlderThan).forEach(this.searchDbService::delete);
    }

    private Set<String> findReferencedSearchIds() {
        HashSet<String> toKeepViewIds = new HashSet<String>();
        toKeepViewIds.addAll(this.viewSummaryService.streamAll().map(ViewSummaryDTO::searchId).collect(Collectors.toSet()));
        toKeepViewIds.addAll(this.viewResolvers.values().stream().flatMap(vr -> vr.getSearchIds().stream()).collect(Collectors.toSet()));
        return toKeepViewIds;
    }
}

