/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.validation.validators;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import org.graylog.plugins.views.search.engine.QueryPosition;
import org.graylog.plugins.views.search.rest.MappedFieldTypeDTO;
import org.graylog.plugins.views.search.validation.ParsedTerm;
import org.graylog.plugins.views.search.validation.QueryValidator;
import org.graylog.plugins.views.search.validation.ValidationContext;
import org.graylog.plugins.views.search.validation.ValidationMessage;
import org.graylog.plugins.views.search.validation.ValidationStatus;
import org.graylog.plugins.views.search.validation.ValidationType;
import org.graylog.plugins.views.search.validation.validators.util.UnknownFieldsListLimiter;

@Singleton
public class UnknownFieldsValidator
implements QueryValidator {
    private final UnknownFieldsListLimiter unknownFieldsListLimiter = new UnknownFieldsListLimiter();

    @Override
    public List<ValidationMessage> validate(ValidationContext context) {
        return this.identifyUnknownFields(context).stream().map(field -> {
            ValidationMessage.Builder message = ValidationMessage.builder(ValidationStatus.WARNING, ValidationType.UNKNOWN_FIELD).relatedProperty(field.getRealFieldName()).errorMessage("Query contains unknown field: " + field.getRealFieldName());
            field.keyToken().map(QueryPosition::from).ifPresent(message::position);
            return message.build();
        }).collect(Collectors.toList());
    }

    private List<ParsedTerm> identifyUnknownFields(ValidationContext context) {
        Set availableFields = context.availableFields().stream().map(MappedFieldTypeDTO::name).collect(Collectors.toSet());
        Map<String, List<ParsedTerm>> groupedByField = context.query().terms().stream().filter(t -> !t.isDefaultField()).filter(term -> !availableFields.contains(term.getRealFieldName())).distinct().collect(Collectors.groupingBy(ParsedTerm::getRealFieldName));
        return this.unknownFieldsListLimiter.filterElementsContainingUsefulInformation(groupedByField);
    }
}

