/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.startpage.lastOpened;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.DuplicateKeyException;
import java.util.Optional;
import javax.inject.Inject;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.startpage.lastOpened.LastOpenedForUserDTO;
import org.graylog.plugins.views.startpage.recentActivities.ActivityType;
import org.graylog.plugins.views.startpage.recentActivities.RecentActivityEvent;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedDbService;
import org.graylog2.users.events.UserDeletedEvent;
import org.mongojack.DBQuery;
import org.mongojack.WriteResult;

public class LastOpenedService
extends PaginatedDbService<LastOpenedForUserDTO> {
    public static final String COLLECTION_NAME = "last_opened";

    @Inject
    public LastOpenedService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, EventBus eventBus) {
        super(mongoConnection, mapper, LastOpenedForUserDTO.class, COLLECTION_NAME);
        eventBus.register((Object)this);
        this.db.createIndex((DBObject)new BasicDBObject("user_id", (Object)1));
        this.db.createIndex((DBObject)new BasicDBObject("items.grn", (Object)1));
    }

    public Optional<LastOpenedForUserDTO> findForUser(SearchUser searchUser) {
        return this.findForUser(searchUser.getUser().getId());
    }

    Optional<LastOpenedForUserDTO> findForUser(String userId) {
        return this.streamQuery(DBQuery.is((String)"user_id", (Object)userId)).findAny();
    }

    public Optional<LastOpenedForUserDTO> create(LastOpenedForUserDTO lastOpenedItems, SearchUser searchUser) {
        try {
            WriteResult result = this.db.insert((Object)lastOpenedItems);
            LastOpenedForUserDTO savedObject = (LastOpenedForUserDTO)result.getSavedObject();
            return Optional.ofNullable(savedObject);
        }
        catch (DuplicateKeyException e) {
            throw new IllegalStateException("Unable to create a last opened collection, collection with this id already exists : " + lastOpenedItems.id());
        }
    }

    @Subscribe
    public void removeLastOpenedOnEntityDeletion(RecentActivityEvent event) {
        if (event.activityType().equals((Object)ActivityType.DELETE)) {
            String grn = event.grn().toString();
            BasicDBObject query = new BasicDBObject("items.grn", (Object)grn);
            BasicDBObject modifications = new BasicDBObject("$pull", (Object)new BasicDBObject("items", (Object)new BasicDBObject("grn", (Object)grn)));
            this.db.updateMulti((DBObject)query, (DBObject)modifications);
        }
    }

    @Subscribe
    public void removeFavoriteEntityOnUserDeletion(UserDeletedEvent event) {
        this.db.remove(DBQuery.is((String)"user_id", (Object)event.userId()));
    }
}

