/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.authservice.backend;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.graylog.security.authservice.AuthServiceBackendConfig;
import org.graylog.security.authservice.backend.AutoValue_LDAPAuthServiceBackendConfig;
import org.graylog.security.authservice.backend.AutoValue_LDAPAuthServiceBackendConfig_HostAndPort;
import org.graylog.security.authservice.ldap.LDAPConnectorConfig;
import org.graylog.security.authservice.ldap.LDAPConnectorConfigProvider;
import org.graylog.security.authservice.ldap.LDAPTransportSecurity;
import org.graylog2.plugin.rest.ValidationResult;
import org.graylog2.security.encryption.EncryptedValue;

@JsonDeserialize(builder=Builder.class)
@JsonTypeName(value="ldap")
@AutoValue
public abstract class LDAPAuthServiceBackendConfig
implements AuthServiceBackendConfig,
LDAPConnectorConfigProvider {
    private static final String FIELD_SERVERS = "servers";
    private static final String FIELD_TRANSPORT_SECURITY = "transport_security";
    private static final String FIELD_VERIFY_CERTIFICATES = "verify_certificates";
    private static final String FIELD_SYSTEM_USER_DN = "system_user_dn";
    private static final String FIELD_SYSTEM_USER_PASSWORD = "system_user_password";
    private static final String FIELD_USER_SEARCH_BASE = "user_search_base";
    private static final String FIELD_USER_SEARCH_PATTERN = "user_search_pattern";
    private static final String FIELD_USER_UNIQUE_ID_ATTRIBUTE = "user_unique_id_attribute";
    private static final String FIELD_USER_NAME_ATTRIBUTE = "user_name_attribute";
    private static final String FIELD_USER_FULL_NAME_ATTRIBUTE = "user_full_name_attribute";
    private static final String FIELD_EMAIL_ATTRIBUTES = "email_attributes";

    @JsonProperty(value="servers")
    public abstract ImmutableList<HostAndPort> servers();

    @JsonProperty(value="transport_security")
    public abstract LDAPTransportSecurity transportSecurity();

    @JsonProperty(value="verify_certificates")
    public abstract boolean verifyCertificates();

    @JsonProperty(value="system_user_dn")
    public abstract String systemUserDn();

    @JsonProperty(value="system_user_password")
    public abstract EncryptedValue systemUserPassword();

    @JsonProperty(value="user_search_base")
    public abstract String userSearchBase();

    @JsonProperty(value="user_search_pattern")
    public abstract String userSearchPattern();

    @JsonProperty(value="user_unique_id_attribute")
    public abstract String userUniqueIdAttribute();

    @JsonProperty(value="user_name_attribute")
    public abstract String userNameAttribute();

    @JsonProperty(value="user_full_name_attribute")
    public abstract String userFullNameAttribute();

    @JsonProperty(value="email_attributes")
    public abstract ImmutableList<String> emailAttributes();

    @Override
    public void validate(ValidationResult result) {
        if (this.servers().isEmpty()) {
            result.addError(FIELD_SERVERS, "Server list cannot be empty.");
        }
        if (StringUtils.isBlank((CharSequence)this.userSearchBase())) {
            result.addError(FIELD_USER_SEARCH_BASE, "User search base cannot be empty.");
        }
        if (StringUtils.isBlank((CharSequence)this.userSearchPattern())) {
            result.addError(FIELD_USER_SEARCH_PATTERN, "User search pattern cannot be empty.");
        } else {
            try {
                Filter.create((String)this.userSearchPattern());
            }
            catch (LDAPException e) {
                result.addError(FIELD_USER_SEARCH_PATTERN, "User search pattern cannot be parsed. It must be a valid LDAP filter.");
            }
        }
        if (StringUtils.isBlank((CharSequence)this.userUniqueIdAttribute())) {
            result.addError(FIELD_USER_UNIQUE_ID_ATTRIBUTE, "User unique ID attribute cannot be empty.");
        }
        if (StringUtils.isBlank((CharSequence)this.userNameAttribute())) {
            result.addError(FIELD_USER_NAME_ATTRIBUTE, "User name attribute cannot be empty.");
        }
        if (StringUtils.isBlank((CharSequence)this.userFullNameAttribute())) {
            result.addError(FIELD_USER_FULL_NAME_ATTRIBUTE, "User full name cannot be empty.");
        }
    }

    @Override
    public LDAPConnectorConfig getLDAPConnectorConfig() {
        return LDAPConnectorConfig.builder().serverList(this.servers().stream().map(hap -> LDAPConnectorConfig.LDAPServer.create(hap.host(), hap.port())).collect(Collectors.toList())).systemUsername(StringUtils.trimToNull((String)this.systemUserDn())).systemPassword(this.systemUserPassword()).transportSecurity(this.transportSecurity()).verifyCertificates(this.verifyCertificates()).build();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return Builder.create();
    }

    @AutoValue.Builder
    public static abstract class Builder
    implements AuthServiceBackendConfig.Builder<Builder> {
        @JsonCreator
        public static Builder create() {
            return new AutoValue_LDAPAuthServiceBackendConfig.Builder().type("ldap").verifyCertificates(true).systemUserDn("").systemUserPassword(EncryptedValue.createUnset()).userUniqueIdAttribute("entryUUID").emailAttributes((List<String>)ImmutableList.of((Object)"mail", (Object)"rfc822Mailbox"));
        }

        @JsonProperty(value="servers")
        public abstract Builder servers(List<HostAndPort> var1);

        @JsonProperty(value="transport_security")
        public abstract Builder transportSecurity(LDAPTransportSecurity var1);

        @JsonProperty(value="verify_certificates")
        public abstract Builder verifyCertificates(boolean var1);

        @JsonProperty(value="system_user_dn")
        public abstract Builder systemUserDn(String var1);

        @JsonProperty(value="system_user_password")
        public abstract Builder systemUserPassword(EncryptedValue var1);

        @JsonProperty(value="user_search_base")
        public abstract Builder userSearchBase(String var1);

        @JsonProperty(value="user_search_pattern")
        public abstract Builder userSearchPattern(String var1);

        @JsonProperty(value="user_unique_id_attribute")
        public abstract Builder userUniqueIdAttribute(String var1);

        @JsonProperty(value="user_name_attribute")
        public abstract Builder userNameAttribute(String var1);

        @JsonProperty(value="user_full_name_attribute")
        public abstract Builder userFullNameAttribute(String var1);

        @JsonProperty(value="email_attributes")
        public abstract Builder emailAttributes(List<String> var1);

        public abstract LDAPAuthServiceBackendConfig build();
    }

    @AutoValue
    public static abstract class HostAndPort {
        @JsonProperty(value="host")
        public abstract String host();

        @JsonProperty(value="port")
        public abstract int port();

        @JsonCreator
        public static HostAndPort create(@JsonProperty(value="host") String host, @JsonProperty(value="port") int port) {
            return new AutoValue_LDAPAuthServiceBackendConfig_HostAndPort(host, port);
        }

        public String toString() {
            return this.host() + ":" + this.port();
        }
    }
}

