/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bootstrap.preflight;

import com.google.common.collect.ImmutableMap;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.bootstrap.preflight.PreflightConfig;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PersistedServiceImpl;
import org.graylog2.plugin.database.ValidationException;

public class PreflightConfigService
extends PersistedServiceImpl {
    @Inject
    public PreflightConfigService(MongoConnection connection) {
        super(connection);
    }

    public Optional<PreflightConfig> getPersistedConfig() {
        DBObject doc = this.findOne(PreflightConfig.class, (DBObject)new BasicDBObject());
        return Optional.ofNullable(doc).map(o -> new PreflightConfig((ObjectId)o.get("_id"), o.toMap()));
    }

    public PreflightConfig saveConfiguration() throws ValidationException {
        ImmutableMap fields = ImmutableMap.of((Object)"finished", (Object)true);
        PreflightConfig config = new PreflightConfig((Map<String, Object>)fields);
        String id = this.save(config);
        return this.getPersistedConfig().orElseThrow(() -> new IllegalStateException("Failed to obtain configuration that was just stored"));
    }
}

