/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bootstrap.preflight.web;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.StringTokenizer;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.digest.DigestUtils;
import org.bouncycastle.util.encoders.Base64;
import org.graylog2.Configuration;

public class PreflightAuthFilter
implements ContainerRequestFilter {
    private static final String AUTHORIZATION_PROPERTY = "Authorization";
    private static final String AUTHENTICATION_SCHEME = "Basic";
    private final String adminUsername;
    private final String adminPasswordHash;

    @Inject
    public PreflightAuthFilter(Configuration configuration) {
        this.adminUsername = configuration.getRootUsername();
        this.adminPasswordHash = configuration.getRootPasswordSha2();
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String password;
        MultivaluedMap headers = requestContext.getHeaders();
        List authorization = (List)headers.get((Object)AUTHORIZATION_PROPERTY);
        if (authorization == null || authorization.isEmpty()) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"You cannot access this resource").header("WWW-Authenticate", (Object)"Basic realm=preflight-config").build());
            return;
        }
        String encodedUserPassword = ((String)authorization.get(0)).replaceFirst("Basic ", "");
        String usernameAndPassword = new String(Base64.decode((byte[])encodedUserPassword.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        StringTokenizer tokenizer = new StringTokenizer(usernameAndPassword, ":");
        String username = tokenizer.nextToken();
        if (!this.isUserMatching(username, password = tokenizer.nextToken())) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"You cannot access this resource").header("WWW-Authenticate", (Object)"Basic realm=preflight-config").build());
        }
    }

    private boolean isUserMatching(String username, String password) {
        return username.equals(this.adminUsername) && this.isPasswordMatching(password);
    }

    private boolean isPasswordMatching(String password) {
        return DigestUtils.sha256Hex((String)password).equals(this.adminPasswordHash);
    }
}

