/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.model.entities;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.graph.Traverser;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.GlobalOverride;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.engine.BackendQuery;
import org.graylog.plugins.views.search.filter.StreamFilter;
import org.graylog.plugins.views.search.searchfilters.model.UsedSearchFilter;
import org.graylog2.contentpacks.NativeEntityConverter;
import org.graylog2.contentpacks.exceptions.ContentPackException;
import org.graylog2.contentpacks.model.ModelTypes;
import org.graylog2.contentpacks.model.entities.AutoValue_QueryEntity;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.SearchTypeEntity;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.graylog2.plugin.streams.Stream;

@JsonAutoDetect
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class QueryEntity
implements NativeEntityConverter<Query> {
    @JsonProperty
    public abstract String id();

    @JsonProperty
    public abstract TimeRange timerange();

    @Nullable
    @JsonProperty
    public abstract Filter filter();

    @JsonProperty
    public abstract List<UsedSearchFilter> filters();

    @Nonnull
    @JsonProperty
    public abstract BackendQuery query();

    @JsonIgnore
    public abstract Optional<GlobalOverride> globalOverride();

    @Nonnull
    @JsonProperty(value="search_types")
    public abstract ImmutableSet<SearchTypeEntity> searchTypes();

    public Set<String> usedStreamIds() {
        return Optional.ofNullable(this.filter()).map(optFilter -> {
            Traverser filterTraverser = Traverser.forTree(filter -> (Iterable)MoreObjects.firstNonNull(filter.filters(), Collections.emptySet()));
            return StreamSupport.stream(filterTraverser.breadthFirst(optFilter).spliterator(), false).filter(filter -> filter instanceof StreamFilter).map(streamFilter -> ((StreamFilter)streamFilter).streamId()).filter(Objects::nonNull).collect(Collectors.toSet());
        }).orElse(Collections.emptySet());
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return Builder.createWithDefaults();
    }

    private Filter shallowMappedFilter(Map<EntityDescriptor, Object> nativeEntities) {
        return Optional.ofNullable(this.filter()).map(optFilter -> {
            Set<Filter> newFilters = optFilter.filters().stream().map(filter -> {
                if (filter.type().matches("stream")) {
                    StreamFilter streamFilter = (StreamFilter)filter;
                    Stream stream = (Stream)nativeEntities.get(EntityDescriptor.create(streamFilter.streamId(), ModelTypes.STREAM_V1));
                    if (Objects.isNull(stream)) {
                        throw new ContentPackException("Could not find matching stream id: " + streamFilter.streamId());
                    }
                    return streamFilter.toBuilder().streamId(stream.getId()).build();
                }
                return filter;
            }).collect(Collectors.toSet());
            return optFilter.toGenericBuilder().filters(newFilters).build();
        }).orElse(null);
    }

    @Override
    public Query toNativeEntity(Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities) {
        return Query.builder().id(this.id()).searchTypes(this.searchTypes().stream().map(s -> (SearchType)s.toNativeEntity(parameters, nativeEntities)).collect(Collectors.toSet())).query(this.query()).filter(this.shallowMappedFilter(nativeEntities)).filters(this.convertSearchFilters(this.filters())).timerange(this.timerange()).globalOverride(this.globalOverride().orElse(null)).build();
    }

    @JsonPOJOBuilder(withPrefix="")
    @AutoValue.Builder
    public static abstract class Builder {
        @JsonProperty
        public abstract Builder id(String var1);

        @JsonProperty
        public abstract Builder timerange(TimeRange var1);

        @JsonProperty
        public abstract Builder filter(Filter var1);

        @JsonProperty
        public abstract Builder filters(List<UsedSearchFilter> var1);

        @JsonProperty
        public abstract Builder query(BackendQuery var1);

        public abstract Builder globalOverride(@Nullable GlobalOverride var1);

        @JsonProperty(value="search_types")
        public abstract Builder searchTypes(@Nullable Set<SearchTypeEntity> var1);

        abstract QueryEntity autoBuild();

        @JsonCreator
        static Builder createWithDefaults() {
            return new AutoValue_QueryEntity.Builder().filters(Collections.emptyList()).searchTypes((Set<SearchTypeEntity>)ImmutableSortedSet.of());
        }

        public QueryEntity build() {
            return this.autoBuild();
        }
    }
}

