/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.ranges;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.primitives.Ints;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.bson.types.ObjectId;
import org.graylog2.audit.AuditActor;
import org.graylog2.audit.AuditEventSender;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.indexer.indices.events.IndicesClosedEvent;
import org.graylog2.indexer.indices.events.IndicesDeletedEvent;
import org.graylog2.indexer.indices.events.IndicesReopenedEvent;
import org.graylog2.indexer.ranges.IndexRange;
import org.graylog2.indexer.ranges.IndexRangeService;
import org.graylog2.indexer.ranges.MongoIndexRange;
import org.graylog2.indexer.searches.IndexRangeStats;
import org.graylog2.plugin.system.NodeId;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MongoIndexRangeService
implements IndexRangeService {
    private static final Logger LOG = LoggerFactory.getLogger(MongoIndexRangeService.class);
    private static final String COLLECTION_NAME = "index_ranges";
    private final Indices indices;
    private final IndexSetRegistry indexSetRegistry;
    private final AuditEventSender auditEventSender;
    private final NodeId nodeId;
    private final JacksonDBCollection<MongoIndexRange, ObjectId> collection;

    @Inject
    public MongoIndexRangeService(MongoConnection mongoConnection, MongoJackObjectMapperProvider objectMapperProvider, Indices indices, IndexSetRegistry indexSetRegistry, AuditEventSender auditEventSender, NodeId nodeId, EventBus eventBus) {
        this.indices = indices;
        this.indexSetRegistry = indexSetRegistry;
        this.auditEventSender = auditEventSender;
        this.nodeId = nodeId;
        this.collection = JacksonDBCollection.wrap((DBCollection)mongoConnection.getDatabase().getCollection(COLLECTION_NAME), MongoIndexRange.class, ObjectId.class, (ObjectMapper)objectMapperProvider.get());
        eventBus.register((Object)this);
        this.collection.createIndex((DBObject)new BasicDBObject("index_name", (Object)1));
        this.collection.createIndex(BasicDBObjectBuilder.start().add("begin", (Object)1).add("end", (Object)1).get());
    }

    @Override
    public IndexRange get(String index) throws NotFoundException {
        DBQuery.Query query = DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.notExists((String)"start"), DBQuery.is((String)"index_name", (Object)index)});
        MongoIndexRange indexRange = (MongoIndexRange)this.collection.findOne(query);
        if (indexRange == null) {
            throw new NotFoundException("Index range for index <" + index + "> not found.");
        }
        return indexRange;
    }

    @Override
    public SortedSet<IndexRange> find(DateTime begin, DateTime end) {
        DBQuery.Query query = DBQuery.or((DBQuery.Query[])new DBQuery.Query[]{DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.notExists((String)"start"), DBQuery.lessThanEquals((String)"begin", (Object)end.getMillis()), DBQuery.greaterThanEquals((String)"end", (Object)begin.getMillis())}), DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.notExists((String)"start"), DBQuery.lessThanEquals((String)"begin", (Object)0L), DBQuery.greaterThanEquals((String)"end", (Object)0L)})});
        try (DBCursor indexRanges = this.collection.find(query);){
            ImmutableSortedSet immutableSortedSet = ImmutableSortedSet.copyOf(IndexRange.COMPARATOR, (Iterator)indexRanges);
            return immutableSortedSet;
        }
    }

    @Override
    public SortedSet<IndexRange> findAll() {
        try (DBCursor cursor = this.collection.find(DBQuery.notExists((String)"start"));){
            ImmutableSortedSet immutableSortedSet = ImmutableSortedSet.copyOf(IndexRange.COMPARATOR, (Iterator)cursor);
            return immutableSortedSet;
        }
    }

    @Override
    public IndexRange calculateRange(String index) {
        Indices.checkIfHealthy(this.indices.waitForRecovery(index), status -> new RuntimeException("Unable to calculate range for index <" + index + ">, index is unhealthy: " + status));
        DateTime now = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        Stopwatch sw = Stopwatch.createStarted();
        IndexRangeStats stats = this.indices.indexRangeStatsOfIndex(index);
        int duration = Ints.saturatedCast((long)sw.stop().elapsed(TimeUnit.MILLISECONDS));
        LOG.info("Calculated range of [{}] in [{}ms].", (Object)index, (Object)duration);
        return MongoIndexRange.create(index, stats.min(), stats.max(), now, duration, stats.streamIds());
    }

    @Override
    public IndexRange createUnknownRange(String index) {
        DateTime begin = new DateTime(0L, DateTimeZone.UTC);
        DateTime end = new DateTime(0L, DateTimeZone.UTC);
        DateTime now = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        return MongoIndexRange.create(index, begin, end, now, 0);
    }

    @Override
    public WriteResult<MongoIndexRange, ObjectId> save(IndexRange indexRange) {
        this.remove(indexRange.indexName());
        WriteResult save = this.collection.save((Object)MongoIndexRange.create(indexRange));
        return save;
    }

    @Override
    public boolean remove(String index) {
        WriteResult remove = this.collection.remove(DBQuery.in((String)"index_name", (Object[])new Object[]{index}));
        return remove.getN() > 0;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void handleIndexDeletion(IndicesDeletedEvent event) {
        for (String index : event.indices()) {
            if (!this.indexSetRegistry.isManagedIndex(index)) {
                LOG.debug("Not handling deleted index <{}> because it's not managed by any index set.", (Object)index);
                continue;
            }
            LOG.debug("Index \"{}\" has been deleted. Removing index range.");
            if (!this.remove(index)) continue;
            this.auditEventSender.success(AuditActor.system(this.nodeId), "server:es_index_range:delete", (Map<String, Object>)ImmutableMap.of((Object)"index_name", (Object)index));
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void handleIndexClosing(IndicesClosedEvent event) {
        for (String index : event.indices()) {
            if (!this.indexSetRegistry.isManagedIndex(index)) {
                LOG.debug("Not handling closed index <{}> because it's not managed by any index set.", (Object)index);
                continue;
            }
            LOG.debug("Index \"{}\" has been closed. Removing index range.");
            if (!this.remove(index)) continue;
            this.auditEventSender.success(AuditActor.system(this.nodeId), "server:es_index_range:delete", (Map<String, Object>)ImmutableMap.of((Object)"index_name", (Object)index));
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void handleIndexReopening(IndicesReopenedEvent event) {
        for (String index : event.indices()) {
            IndexRange indexRange;
            if (!this.indexSetRegistry.isManagedIndex(index)) {
                LOG.debug("Not handling reopened index <{}> because it's not managed by any index set.", (Object)index);
                continue;
            }
            LOG.debug("Index \"{}\" has been reopened. Calculating index range.", (Object)index);
            Indices.checkIfHealthy(this.indices.waitForRecovery(index), status -> new RuntimeException("Not handling reopened index <" + index + ">, index is unhealthy: " + status));
            try {
                indexRange = this.calculateRange(index);
                this.auditEventSender.success(AuditActor.system(this.nodeId), "server:es_index_range:create", (Map<String, Object>)ImmutableMap.of((Object)"index_name", (Object)index));
            }
            catch (Exception e) {
                String message = "Couldn't calculate index range for index \"" + index + "\"";
                LOG.error(message, (Throwable)e);
                this.auditEventSender.failure(AuditActor.system(this.nodeId), "server:es_index_range:create", (Map<String, Object>)ImmutableMap.of((Object)"index_name", (Object)index));
                throw new RuntimeException(message, e);
            }
            this.save(indexRange);
        }
    }
}

