/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog.grn.GRN;
import org.graylog2.contentpacks.ContentPackService;
import org.graylog2.contentpacks.model.entities.EntityExcerpt;

@Singleton
public class Catalog {
    private final ContentPackService contentPackService;
    private final LoadingCache<String, Entry> cache;
    private final int MAXIMUM_CACHE_SIZE = 10000;

    @Inject
    public Catalog(ContentPackService contentPackService) {
        this.contentPackService = contentPackService;
        this.cache = this.createCache();
    }

    protected LoadingCache<String, Entry> createCache() {
        return CacheBuilder.newBuilder().maximumSize(10000L).expireAfterAccess(1L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, Entry>(){

            public Entry load(String id) {
                Map<String, EntityExcerpt> catalog = Catalog.this.contentPackService.getEntityExcerpts();
                EntityExcerpt excerpt = catalog.get(id);
                if (excerpt != null) {
                    return new Entry(excerpt.type().name(), excerpt.title());
                }
                return new Entry("Unknown entity: " + id, "Unknown entity: " + id);
            }
        });
    }

    public String getTitle(GRN grn) {
        try {
            Entry item = (Entry)this.cache.get((Object)grn.entity());
            if (item.title() != null) {
                return item.title();
            }
            return "Unknown entity: " + grn;
        }
        catch (ExecutionException cex) {
            return "Unknown entity: " + grn;
        }
    }

    public String getType(GRN grn) {
        try {
            Entry item = (Entry)this.cache.get((Object)grn.entity());
            if (item.type() != null) {
                return item.type().toLowerCase(Locale.ROOT);
            }
            return "Unknown entity: " + grn;
        }
        catch (ExecutionException cex) {
            return "Unknown entity: " + grn;
        }
    }

    protected record Entry(String type, String title) {
    }
}

