/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.client.MongoCollection;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.bson.Document;
import org.graylog2.database.MongoConnection;
import org.graylog2.inputs.encryption.EncryptedInputConfigMigration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.shared.inputs.MessageInputFactory;

public class V20230213160000_EncryptedInputConfigMigration
extends EncryptedInputConfigMigration {
    @Inject
    public V20230213160000_EncryptedInputConfigMigration(ClusterConfigService clusterConfigService, MongoConnection mongoConnection, MessageInputFactory messageInputFactory, ObjectMapper objectMapper) {
        super(clusterConfigService, mongoConnection, messageInputFactory, objectMapper);
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2023-02-13T16:00:00Z");
    }

    @Override
    protected Map<String, Set<String>> getMigratedField() {
        return this.clusterConfigService.getOrDefault(MigrationCompleted.class, new MigrationCompleted(Map.of())).migratedFields();
    }

    @Override
    protected MongoCollection<Document> getCollection() {
        return this.mongoConnection.getMongoDatabase().getCollection("inputs");
    }

    @Override
    protected void saveMigrationCompleted(Map<String, Set<String>> encryptedFieldsByInputType) {
        this.clusterConfigService.write(new MigrationCompleted(encryptedFieldsByInputType));
    }

    public record MigrationCompleted(@JsonProperty(value="migrated_fields") Map<String, Set<String>> migratedFields) {
    }
}

