/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin;

import com.github.joschi.jadconfig.Parameter;
import com.github.joschi.jadconfig.ValidationException;
import com.github.joschi.jadconfig.ValidatorMethod;
import com.github.joschi.jadconfig.util.Duration;
import com.github.joschi.jadconfig.validators.PositiveDurationValidator;
import com.github.joschi.jadconfig.validators.PositiveIntegerValidator;
import com.github.joschi.jadconfig.validators.StringNotBlankValidator;
import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.BusySpinWaitStrategy;
import com.lmax.disruptor.SleepingWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.YieldingWaitStrategy;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.graylog2.configuration.PathConfiguration;
import org.graylog2.utilities.ProxyHostsPattern;
import org.graylog2.utilities.ProxyHostsPatternConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseConfiguration
extends PathConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(BaseConfiguration.class);
    @Parameter(value="shutdown_timeout", validator=PositiveIntegerValidator.class)
    protected int shutdownTimeout = 30000;
    @Parameter(value="processbuffer_processors", required=true, validator=PositiveIntegerValidator.class)
    private int processBufferProcessors = 5;
    @Parameter(value="processor_wait_strategy", required=true)
    private String processorWaitStrategy = "blocking";
    @Parameter(value="ring_size", required=true, validator=PositiveIntegerValidator.class)
    private int ringSize = 65536;
    @Parameter(value="inputbuffer_ring_size", required=true, validator=PositiveIntegerValidator.class)
    private int inputBufferRingSize = 65536;
    @Parameter(value="inputbuffer_wait_strategy", required=true)
    private String inputBufferWaitStrategy = "blocking";
    @Parameter(value="async_eventbus_processors")
    private int asyncEventbusProcessors = 2;
    @Parameter(value="udp_recvbuffer_sizes", required=true, validator=PositiveIntegerValidator.class)
    private int udpRecvBufferSizes = 0x100000;
    @Parameter(value="message_journal_enabled")
    private boolean messageJournalEnabled = true;
    @Parameter(value="message_journal_mode")
    private String messageJournalMode = "disk";
    @Parameter(value="inputbuffer_processors")
    private int inputbufferProcessors = 2;
    @Parameter(value="message_recordings_enable")
    private boolean messageRecordingsEnable = false;
    @Parameter(value="disable_native_system_stats_collector")
    private boolean disableNativeSystemStatsCollector = false;
    @Parameter(value="http_proxy_uri")
    private URI httpProxyUri;
    @Parameter(value="http_non_proxy_hosts", converter=ProxyHostsPatternConverter.class)
    private ProxyHostsPattern httpNonProxyHostsPattern;
    @Parameter(value="http_connect_timeout", validator=PositiveDurationValidator.class)
    private Duration httpConnectTimeout = Duration.seconds((long)5L);
    @Parameter(value="http_write_timeout", validator=PositiveDurationValidator.class)
    private Duration httpWriteTimeout = Duration.seconds((long)10L);
    @Parameter(value="http_read_timeout", validator=PositiveDurationValidator.class)
    private Duration httpReadTimeout = Duration.seconds((long)10L);
    @Parameter(value="installation_source", validator=StringNotBlankValidator.class)
    private String installationSource = "unknown";
    @Parameter(value="proxied_requests_thread_pool_size", required=true, validator=PositiveIntegerValidator.class)
    private int proxiedRequestsThreadPoolSize = 64;
    @Parameter(value="proxied_requests_default_call_timeout", required=true, validator=PositiveDurationValidator.class)
    private Duration proxiedRequestsDefaultCallTimeout = Duration.seconds((long)5L);

    public int getProcessBufferProcessors() {
        return this.processBufferProcessors;
    }

    private WaitStrategy getWaitStrategy(String waitStrategyName, String configOptionName) {
        switch (waitStrategyName) {
            case "sleeping": {
                return new SleepingWaitStrategy();
            }
            case "yielding": {
                return new YieldingWaitStrategy();
            }
            case "blocking": {
                return new BlockingWaitStrategy();
            }
            case "busy_spinning": {
                return new BusySpinWaitStrategy();
            }
        }
        LOG.warn("Invalid setting for [{}]: Falling back to default: BlockingWaitStrategy.", (Object)configOptionName);
        return new BlockingWaitStrategy();
    }

    public WaitStrategy getProcessorWaitStrategy() {
        return this.getWaitStrategy(this.processorWaitStrategy, "processbuffer_wait_strategy");
    }

    public int getRingSize() {
        return this.ringSize;
    }

    public int getInputBufferRingSize() {
        return this.inputBufferRingSize;
    }

    public WaitStrategy getInputBufferWaitStrategy() {
        return this.getWaitStrategy(this.inputBufferWaitStrategy, "inputbuffer_wait_strategy");
    }

    public int getAsyncEventbusProcessors() {
        return this.asyncEventbusProcessors;
    }

    public boolean isMessageJournalEnabled() {
        return this.messageJournalEnabled;
    }

    public void setMessageJournalEnabled(boolean messageJournalEnabled) {
        this.messageJournalEnabled = messageJournalEnabled;
    }

    public int getInputbufferProcessors() {
        return this.inputbufferProcessors;
    }

    public int getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public int getUdpRecvBufferSizes() {
        return this.udpRecvBufferSizes;
    }

    public boolean isMessageRecordingsEnabled() {
        return this.messageRecordingsEnable;
    }

    public boolean isDisableNativeSystemStatsCollector() {
        return this.disableNativeSystemStatsCollector;
    }

    public URI getHttpProxyUri() {
        return this.httpProxyUri;
    }

    public ProxyHostsPattern getHttpNonProxyHostsPattern() {
        return this.httpNonProxyHostsPattern;
    }

    public Duration getHttpConnectTimeout() {
        return this.httpConnectTimeout;
    }

    public Duration getHttpWriteTimeout() {
        return this.httpWriteTimeout;
    }

    public Duration getHttpReadTimeout() {
        return this.httpReadTimeout;
    }

    public String getInstallationSource() {
        return this.installationSource;
    }

    public String getMessageJournalMode() {
        return this.messageJournalEnabled ? this.messageJournalMode : "noop";
    }

    @ValidatorMethod
    public void validateJournalMode() throws ValidationException {
        if (!this.messageJournalEnabled) {
            return;
        }
        if (this.messageJournalMode.equals("noop")) {
            throw new ValidationException("Setting message journal mode to <noop> without disabling the message journal is not supported.");
        }
        if (StringUtils.isBlank((CharSequence)this.messageJournalMode)) {
            throw new ValidationException("Journal mode (e.g. <disk>) needs to be provided when the journal is enabled.");
        }
    }
}

