/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.bulk;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.LinkedList;
import javax.ws.rs.BadRequestException;
import org.graylog.security.HasUser;
import org.graylog2.audit.AuditEventSender;
import org.graylog2.audit.jersey.DefaultFailureContextCreator;
import org.graylog2.audit.jersey.DefaultSuccessContextCreator;
import org.graylog2.audit.jersey.FailureContextCreator;
import org.graylog2.audit.jersey.ResponseEntityConverter;
import org.graylog2.audit.jersey.SuccessContextCreator;
import org.graylog2.rest.bulk.AuditParams;
import org.graylog2.rest.bulk.BulkExecutor;
import org.graylog2.rest.bulk.SingleEntityOperationExecutor;
import org.graylog2.rest.bulk.model.BulkOperationFailure;
import org.graylog2.rest.bulk.model.BulkOperationRequest;
import org.graylog2.rest.bulk.model.BulkOperationResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequentialBulkExecutor<T, C extends HasUser>
implements BulkExecutor<T, C> {
    private static final Logger LOG = LoggerFactory.getLogger(SequentialBulkExecutor.class);
    static final String NO_ENTITY_IDS_ERROR = "No IDs provided in the request";
    private final SingleEntityOperationExecutor<T, C> singleEntityOperationExecutor;
    private final AuditEventSender auditEventSender;
    private final SuccessContextCreator<T> successAuditLogContextCreator;
    private final FailureContextCreator failureAuditLogContextCreator;

    public SequentialBulkExecutor(SingleEntityOperationExecutor<T, C> singleEntityOperationExecutor, AuditEventSender auditEventSender, ObjectMapper objectMapper) {
        this.singleEntityOperationExecutor = singleEntityOperationExecutor;
        this.auditEventSender = auditEventSender;
        this.successAuditLogContextCreator = new DefaultSuccessContextCreator(new ResponseEntityConverter(objectMapper));
        this.failureAuditLogContextCreator = new DefaultFailureContextCreator();
    }

    public SequentialBulkExecutor(SingleEntityOperationExecutor<T, C> singleEntityOperationExecutor, AuditEventSender auditEventSender, SuccessContextCreator<T> successAuditLogContextCreator, FailureContextCreator failureAuditLogContextCreator) {
        this.singleEntityOperationExecutor = singleEntityOperationExecutor;
        this.auditEventSender = auditEventSender;
        this.successAuditLogContextCreator = successAuditLogContextCreator;
        this.failureAuditLogContextCreator = failureAuditLogContextCreator;
    }

    @Override
    public BulkOperationResponse executeBulkOperation(BulkOperationRequest bulkOperationRequest, C userContext, AuditParams params) {
        if (bulkOperationRequest.entityIds() == null || bulkOperationRequest.entityIds().isEmpty()) {
            throw new BadRequestException(NO_ENTITY_IDS_ERROR);
        }
        LinkedList<BulkOperationFailure> capturedFailures = new LinkedList<BulkOperationFailure>();
        for (String entityId : bulkOperationRequest.entityIds()) {
            try {
                T entityModel = this.singleEntityOperationExecutor.execute(entityId, userContext);
                try {
                    if (params == null) continue;
                    this.auditEventSender.success(this.getAuditActor(userContext), params.eventType(), this.successAuditLogContextCreator.create(entityModel, params.entityClass()));
                }
                catch (Exception auditLogStoreException) {
                    LOG.error("Failed to store in the audit log information about successful entity removal via bulk action ", (Throwable)auditLogStoreException);
                }
            }
            catch (Exception ex) {
                capturedFailures.add(new BulkOperationFailure(entityId, ex.getMessage()));
                try {
                    if (params == null) continue;
                    this.auditEventSender.failure(this.getAuditActor(userContext), params.eventType(), this.failureAuditLogContextCreator.create(params.entityIdInPathParam(), entityId));
                }
                catch (Exception auditLogStoreException) {
                    LOG.error("Failed to store in the audit log information about failed entity removal via bulk action ", (Throwable)auditLogStoreException);
                }
            }
        }
        return new BulkOperationResponse(bulkOperationRequest.entityIds().size() - capturedFailures.size(), capturedFailures);
    }
}

