/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.indexer;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.ServiceUnavailableException;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.indexer.cluster.Cluster;
import org.graylog2.indexer.counts.Counts;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.indexer.indices.TooManyAliasesException;
import org.graylog2.indexer.indices.util.NumberBasedIndexNameComparator;
import org.graylog2.rest.models.count.responses.MessageCountResponse;
import org.graylog2.rest.models.system.deflector.responses.DeflectorSummary;
import org.graylog2.rest.models.system.indexer.responses.IndexRangeSummary;
import org.graylog2.rest.models.system.indexer.responses.IndexSizeSummary;
import org.graylog2.rest.models.system.indexer.responses.IndexSummary;
import org.graylog2.rest.models.system.indexer.responses.IndexerClusterOverview;
import org.graylog2.rest.models.system.indexer.responses.IndexerOverview;
import org.graylog2.rest.resources.system.DeflectorResource;
import org.graylog2.rest.resources.system.IndexRangesResource;
import org.graylog2.rest.resources.system.indexer.IndexerClusterResource;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="Indexer/Overview", description="Indexing overview", tags={"cloud"})
@Path(value="/system/indexer/overview")
public class IndexerOverviewResource
extends RestResource {
    private final DeflectorResource deflectorResource;
    private final IndexerClusterResource indexerClusterResource;
    private final IndexRangesResource indexRangesResource;
    private final Counts counts;
    private final IndexSetRegistry indexSetRegistry;
    private final Indices indices;
    private final Cluster cluster;

    @Inject
    public IndexerOverviewResource(DeflectorResource deflectorResource, IndexerClusterResource indexerClusterResource, IndexRangesResource indexRangesResource, Counts counts, IndexSetRegistry indexSetRegistry, Indices indices, Cluster cluster) {
        this.deflectorResource = deflectorResource;
        this.indexerClusterResource = indexerClusterResource;
        this.indexRangesResource = indexRangesResource;
        this.counts = counts;
        this.indexSetRegistry = indexSetRegistry;
        this.indices = indices;
        this.cluster = cluster;
    }

    @GET
    @Timed
    @ApiOperation(value="Get overview of current indexing state, including deflector config, cluster state, index ranges & message counts.")
    @Produces(value={"application/json"})
    @Deprecated
    public IndexerOverview index() throws TooManyAliasesException {
        if (!this.cluster.isConnected()) {
            throw new ServiceUnavailableException("Elasticsearch cluster is not available, check your configuration and logs for more information.");
        }
        try {
            return this.getIndexerOverview(this.indexSetRegistry.getDefault());
        }
        catch (IllegalStateException e) {
            throw new NotFoundException("Default index set not found");
        }
    }

    @GET
    @Timed
    @Path(value="/{indexSetId}")
    @ApiOperation(value="Get overview of current indexing state for the given index set, including deflector config, cluster state, index ranges & message counts.")
    @Produces(value={"application/json"})
    public IndexerOverview index(@ApiParam(name="indexSetId") @PathParam(value="indexSetId") String indexSetId) throws TooManyAliasesException {
        if (!this.cluster.isConnected()) {
            throw new ServiceUnavailableException("Elasticsearch cluster is not available, check your configuration and logs for more information.");
        }
        IndexSet indexSet = this.getIndexSet(this.indexSetRegistry, indexSetId);
        return this.getIndexerOverview(indexSet);
    }

    private IndexerOverview getIndexerOverview(IndexSet indexSet) throws TooManyAliasesException {
        String indexSetId = indexSet.getConfig().id();
        DeflectorSummary deflectorSummary = this.deflectorResource.deflector(indexSetId);
        List<IndexRangeSummary> indexRanges = this.indexRangesResource.list().ranges();
        JsonNode indexStats = this.indices.getIndexStats(indexSet);
        ArrayList<String> indexNames = new ArrayList<String>();
        indexStats.fieldNames().forEachRemaining(indexNames::add);
        Map<String, Boolean> areReopened = this.indices.areReopened(indexNames);
        List<IndexSummary> indicesSummaries = this.buildIndexSummaries(deflectorSummary, indexSet, indexRanges, indexStats, areReopened);
        return IndexerOverview.create(deflectorSummary, IndexerClusterOverview.create(this.indexerClusterResource.clusterHealth(), this.indexerClusterResource.clusterName().name()), MessageCountResponse.create(this.counts.total(indexSet)), indicesSummaries);
    }

    private List<IndexSummary> buildIndexSummaries(DeflectorSummary deflectorSummary, IndexSet indexSet, List<IndexRangeSummary> indexRanges, JsonNode indexStats, Map<String, Boolean> areReopened) {
        Iterator fields = indexStats.fields();
        ArrayList<IndexSummary> indexSummaries = new ArrayList<IndexSummary>();
        while (fields.hasNext()) {
            Map.Entry entry = (Map.Entry)fields.next();
            indexSummaries.add(this.buildIndexSummary(entry, indexRanges, deflectorSummary, areReopened));
        }
        this.indices.getClosedIndices(indexSet).forEach(indexName -> indexSummaries.add(IndexSummary.create(indexName, null, indexRanges.stream().filter(indexRangeSummary -> indexRangeSummary.indexName().equals(indexName)).findFirst().orElse(null), indexName.equals(deflectorSummary.currentTarget()), true, false)));
        indexSummaries.sort(Comparator.comparing(IndexSummary::indexName, new NumberBasedIndexNameComparator("_")));
        return indexSummaries;
    }

    private IndexSummary buildIndexSummary(Map.Entry<String, JsonNode> indexStats, List<IndexRangeSummary> indexRanges, DeflectorSummary deflectorSummary, Map<String, Boolean> areReopened) {
        String index = indexStats.getKey();
        JsonNode primaries = indexStats.getValue().path("primaries");
        JsonNode docs = primaries.path("docs");
        long count = docs.path("count").asLong();
        long deleted = docs.path("deleted").asLong();
        JsonNode store = primaries.path("store");
        long sizeInBytes = store.path("size_in_bytes").asLong();
        Optional<IndexRangeSummary> range = indexRanges.stream().filter(indexRangeSummary -> indexRangeSummary.indexName().equals(index)).findFirst();
        boolean isDeflector = index.equals(deflectorSummary.currentTarget());
        boolean isReopened = areReopened.get(index);
        return IndexSummary.create(indexStats.getKey(), IndexSizeSummary.create(count, deleted, sizeInBytes), range.orElse(null), isDeflector, false, isReopened);
    }
}

