/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.buffers.processors;

import com.google.common.annotations.VisibleForTesting;
import de.huxhorn.sulky.ulid.ULID;
import java.security.SecureRandom;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.plugin.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MessageULIDGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(MessageULIDGenerator.class);
    private final ULID ulid;
    private final SecureRandom random;

    @Inject
    public MessageULIDGenerator(ULID ulid) {
        this.ulid = ulid;
        this.random = new SecureRandom();
    }

    public String createULID(Message message) {
        this.checkTimestamp(message.getTimestamp().getMillis());
        try {
            return this.createULID(message.getTimestamp().getMillis(), message.getSequenceNr());
        }
        catch (Exception e) {
            LOG.error("Exception while creating ULID.", (Throwable)e);
            return this.ulid.nextULID(message.getTimestamp().getMillis());
        }
    }

    @VisibleForTesting
    String createULID(long timestamp, int sequenceNr) {
        long msbSeq = sequenceNr >>> 16;
        long lsbSeq = sequenceNr & 0xFFFF;
        long msbWithoutRandom = timestamp << 16;
        long lsbWithoutRandom = lsbSeq << 48;
        long nextRandom = this.random.nextLong();
        ULID.Value sequencedULID = new ULID.Value(msbWithoutRandom | msbSeq, lsbWithoutRandom | nextRandom >>> 16);
        return sequencedULID.toString();
    }

    private void checkTimestamp(long timestamp) {
        long TIMESTAMP_OVERFLOW_MASK = -281474976710656L;
        if ((timestamp & 0xFFFF000000000000L) != 0L) {
            throw new IllegalArgumentException("ULID does not support timestamps after +10889-08-02T05:31:50.655Z!");
        }
    }
}

