/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest.resources.csp;

import com.google.inject.Inject;
import java.lang.reflect.Method;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.FeatureContext;
import org.graylog2.shared.rest.resources.csp.CSP;
import org.graylog2.shared.rest.resources.csp.CSPResponseFilter;
import org.graylog2.shared.rest.resources.csp.CSPService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSPDynamicFeature
implements DynamicFeature {
    private static final Logger LOG = LoggerFactory.getLogger(CSPDynamicFeature.class);
    private final CSPService cspService;

    @Inject
    public CSPDynamicFeature(@Context CSPService cspService) {
        this.cspService = cspService;
    }

    public String dynamicCspString() {
        return this.dynamicCspString("default-src 'self'; style-src 'self' 'unsafe-inline'; script-src 'self' 'unsafe-eval'; img-src data: *; connect-src *");
    }

    public String dynamicCspString(String staticCspString) {
        if (!staticCspString.contains("connect-src")) {
            return staticCspString + "connect-src " + this.cspService.connectSrcValue();
        }
        return staticCspString;
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        Method resourceMethod = resourceInfo.getResourceMethod();
        Class resourceClass = resourceInfo.getResourceClass();
        String cspValue = null;
        if (resourceClass != null && resourceClass.isAnnotationPresent(CSP.class)) {
            cspValue = this.dynamicCspString(resourceClass.getAnnotation(CSP.class).value());
            LOG.debug("CSP class annotation for {}: {}", (Object)resourceClass.getSimpleName(), (Object)cspValue);
        } else if (resourceMethod != null && resourceMethod.isAnnotationPresent(CSP.class)) {
            cspValue = this.dynamicCspString(resourceMethod.getAnnotation(CSP.class).value());
            LOG.debug("CSP method annotation for {}: {}", (Object)resourceMethod.getName(), (Object)cspValue);
        }
        if (cspValue != null) {
            CSPResponseFilter filter = new CSPResponseFilter(cspValue);
            context.register((Object)filter);
        }
    }
}

