/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.streams;

import org.graylog2.plugin.streams.StreamRuleType;
import org.graylog2.streams.InvalidStreamRuleTypeException;
import org.graylog2.streams.matchers.AlwaysMatcher;
import org.graylog2.streams.matchers.ContainsMatcher;
import org.graylog2.streams.matchers.ExactMatcher;
import org.graylog2.streams.matchers.FieldPresenceMatcher;
import org.graylog2.streams.matchers.GreaterMatcher;
import org.graylog2.streams.matchers.InputMatcher;
import org.graylog2.streams.matchers.RegexMatcher;
import org.graylog2.streams.matchers.SmallerMatcher;
import org.graylog2.streams.matchers.StreamRuleMatcher;

public class StreamRuleMatcherFactory {
    public static StreamRuleMatcher build(StreamRuleType ruleType) throws InvalidStreamRuleTypeException {
        switch (ruleType) {
            case EXACT: {
                return new ExactMatcher();
            }
            case REGEX: {
                return new RegexMatcher();
            }
            case GREATER: {
                return new GreaterMatcher();
            }
            case SMALLER: {
                return new SmallerMatcher();
            }
            case PRESENCE: {
                return new FieldPresenceMatcher();
            }
            case CONTAINS: {
                return new ContainsMatcher();
            }
            case ALWAYS_MATCH: {
                return new AlwaysMatcher();
            }
            case MATCH_INPUT: {
                return new InputMatcher();
            }
        }
        throw new InvalidStreamRuleTypeException();
    }
}

