/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.telemetry.cluster.db;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.model.Updates;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.bson.Document;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.indices.MongoDbIndexTools;

public class DBTelemetryClusterInfo {
    public static final String FIELD_NODE_ID = "node_id";
    public static final String FIELD_IS_LEADER = "is_leader";
    public static final String FIELD_VERSION = "version";
    private static final String FIELD_ID = "_id";
    private static final String FIELD_UPDATED_AT = "updated_at";
    private static final String COLLECTION_NAME = "telemetry_cluster_infos";
    private final MongoCollection<Document> collection;

    @Inject
    public DBTelemetryClusterInfo(@Named(value="telemetry_cluster_info_ttl") Duration telemetryClusterInfoTtl, MongoConnection mongoConnection) {
        this.collection = mongoConnection.getMongoDatabase().getCollection(COLLECTION_NAME);
        this.collection.createIndex(Indexes.ascending((String[])new String[]{FIELD_NODE_ID}), new IndexOptions().unique(true));
        MongoDbIndexTools.ensureTTLIndex(this.collection, telemetryClusterInfoTtl, FIELD_UPDATED_AT);
    }

    public void update(Map<String, Object> nodeInfo, String nodeId) {
        List updateValues = nodeInfo.entrySet().stream().map(entry -> Updates.set((String)((String)entry.getKey()), entry.getValue())).collect(Collectors.toList());
        updateValues.add(Updates.currentDate((String)FIELD_UPDATED_AT));
        this.collection.findOneAndUpdate(Filters.eq((String)FIELD_NODE_ID, (Object)nodeId), Updates.combine(updateValues), new FindOneAndUpdateOptions().upsert(true));
    }

    public Map<String, Map<String, Object>> findAll() {
        LinkedHashMap<String, Map<String, Object>> nodes = new LinkedHashMap<String, Map<String, Object>>();
        for (Document document : this.collection.find()) {
            nodes.put(document.getString((Object)FIELD_NODE_ID), document.entrySet().stream().filter(entry -> !FIELD_UPDATED_AT.equals(entry.getKey())).filter(entry -> !FIELD_ID.equals(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
        return nodes;
    }
}

