/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.configuration;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import org.graylog.events.configuration.AutoValue_EventsConfiguration;
import org.joda.time.Duration;

@JsonAutoDetect
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class EventsConfiguration {
    private static final String FIELD_SEARCH_TIMEOUT = "events_search_timeout";
    private static final String FIELD_NOTIFICATIONS_RETRY_PERIOD = "events_notification_retry_period";
    private static final String FIELD_NOTIFICATIONS_DEFAULT_BACKLOG = "events_notification_default_backlog";
    private static final String FIELD_CATCHUP_WINDOW = "events_catchup_window";
    private static final String FIELD_NOTIFICATIONS_KEEP_ALIVE_PROBE = "events_notification_tcp_keepalive";
    private static final long DEFAULT_SEARCH_TIMEOUT_MS = 60000L;
    private static final long DEFAULT_NOTIFICATIONS_RETRY_MS = 300000L;
    private static final long DEFAULT_NOTIFICATIONS_BACKLOG = 50L;
    public static final long DEFAULT_CATCH_UP_WINDOW_MS = Duration.standardHours((long)1L).getMillis();
    private static final boolean DEFAULT_NOTIFICATIONS_KEEP_ALIVE_PROBE = false;

    @JsonProperty(value="events_search_timeout")
    public abstract long eventsSearchTimeout();

    @JsonProperty(value="events_notification_retry_period")
    public abstract long eventNotificationsRetry();

    @JsonProperty(value="events_notification_default_backlog")
    public abstract long eventNotificationsBacklog();

    @JsonProperty(value="events_catchup_window")
    public abstract long eventCatchupWindow();

    @JsonProperty(value="events_notification_tcp_keepalive")
    public abstract boolean notificationsKeepAliveProbe();

    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        public static Builder create() {
            return new AutoValue_EventsConfiguration.Builder().eventsSearchTimeout(60000L).eventNotificationsRetry(300000L).eventNotificationsBacklog(50L).eventCatchupWindow(DEFAULT_CATCH_UP_WINDOW_MS).notificationsKeepAliveProbe(false);
        }

        @JsonProperty(value="events_search_timeout")
        public abstract Builder eventsSearchTimeout(long var1);

        @JsonProperty(value="events_notification_retry_period")
        public abstract Builder eventNotificationsRetry(long var1);

        @JsonProperty(value="events_notification_default_backlog")
        public abstract Builder eventNotificationsBacklog(long var1);

        @JsonProperty(value="events_catchup_window")
        public abstract Builder eventCatchupWindow(long var1);

        @JsonProperty(value="events_notification_tcp_keepalive")
        public abstract Builder notificationsKeepAliveProbe(boolean var1);

        public abstract EventsConfiguration build();
    }
}

