/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Sets;
import com.google.common.graph.Traverser;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.AutoValue_Query;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.GlobalOverride;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.elasticsearch.ElasticsearchQueryString;
import org.graylog.plugins.views.search.engine.BackendQuery;
import org.graylog.plugins.views.search.engine.EmptyTimeRange;
import org.graylog.plugins.views.search.filter.AndFilter;
import org.graylog.plugins.views.search.filter.StreamFilter;
import org.graylog.plugins.views.search.rest.ExecutionState;
import org.graylog.plugins.views.search.rest.ExecutionStateGlobalOverride;
import org.graylog.plugins.views.search.rest.SearchTypeExecutionState;
import org.graylog.plugins.views.search.searchfilters.model.ReferencedSearchFilter;
import org.graylog.plugins.views.search.searchfilters.model.UsedSearchFilter;
import org.graylog.plugins.views.search.searchfilters.model.UsesSearchFilters;
import org.graylog2.contentpacks.ContentPackable;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.contentpacks.model.ModelTypes;
import org.graylog2.contentpacks.model.entities.QueryEntity;
import org.graylog2.contentpacks.model.entities.SearchTypeEntity;
import org.graylog2.plugin.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.plugin.indexer.searches.timeranges.RelativeRange;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

@JsonAutoDetect
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class Query
implements ContentPackable<QueryEntity>,
UsesSearchFilters {
    @Nullable
    @JsonProperty
    public abstract String id();

    @JsonProperty
    public abstract TimeRange timerange();

    @Nullable
    @JsonProperty
    public abstract Filter filter();

    @Override
    @JsonProperty
    public abstract List<UsedSearchFilter> filters();

    @Nonnull
    @JsonProperty
    public abstract BackendQuery query();

    @JsonIgnore
    public abstract Optional<GlobalOverride> globalOverride();

    public TimeRange effectiveTimeRange(SearchType searchType) {
        return searchType.timerange().map(timeRange -> timeRange.effectiveTimeRange(this, searchType)).orElse(this.timerange());
    }

    public Set<String> effectiveStreams(SearchType searchType) {
        return searchType.effectiveStreams().isEmpty() ? this.usedStreamIds() : searchType.effectiveStreams();
    }

    @Nonnull
    @JsonProperty(value="search_types")
    public abstract ImmutableSet<SearchType> searchTypes();

    public abstract Builder toBuilder();

    public static Builder builder() {
        return Builder.createWithDefaults();
    }

    public Query applyExecutionState(ExecutionState executionState) {
        if (executionState.globalOverride().hasValues()) {
            return this.applyExecutionState(executionState.globalOverride());
        }
        ExecutionStateGlobalOverride queryOverride = (ExecutionStateGlobalOverride)executionState.queries().get((Object)this.id());
        return this.applyExecutionState(queryOverride);
    }

    Query applyExecutionState(ExecutionStateGlobalOverride state) {
        if (state == null || !state.hasValues()) {
            return this;
        }
        if (state.timerange().isPresent() || state.query().isPresent() || !state.searchTypes().isEmpty() || !state.keepSearchTypes().isEmpty() || !state.keepQueries().isEmpty()) {
            Builder builder = this.toBuilder();
            if (state.timerange().isPresent() || state.query().isPresent()) {
                GlobalOverride.Builder globalOverrideBuilder = this.globalOverride().map(GlobalOverride::toBuilder).orElseGet(GlobalOverride::builder);
                state.timerange().ifPresent(timeRange -> {
                    globalOverrideBuilder.timerange((TimeRange)timeRange);
                    builder.timerange((TimeRange)timeRange);
                });
                state.query().ifPresent(query -> {
                    globalOverrideBuilder.query((BackendQuery)query);
                    builder.query((BackendQuery)query);
                });
                builder.globalOverride(globalOverrideBuilder.build());
            }
            if (!state.searchTypes().isEmpty() || !state.keepSearchTypes().isEmpty()) {
                ImmutableSet<SearchType> searchTypesToKeep = !state.keepSearchTypes().isEmpty() ? this.filterForWhiteListFromState((Set<SearchType>)this.searchTypes(), state) : this.searchTypes();
                Set<SearchType> searchTypesWithOverrides = this.applyAvailableOverrides(state, (Set<SearchType>)searchTypesToKeep);
                builder.searchTypes((Set<SearchType>)ImmutableSet.copyOf(searchTypesWithOverrides));
            }
            return builder.build();
        }
        return this;
    }

    private Set<SearchType> filterForWhiteListFromState(Set<SearchType> previousSearchTypes, ExecutionStateGlobalOverride state) {
        return previousSearchTypes.stream().filter(st -> state.keepSearchTypes().contains((Object)st.id())).collect(Collectors.toSet());
    }

    private Set<SearchType> applyAvailableOverrides(ExecutionStateGlobalOverride state, Set<SearchType> searchTypes) {
        return searchTypes.stream().map(st -> {
            if (state.searchTypes().containsKey((Object)st.id())) {
                SearchTypeExecutionState executionState = (SearchTypeExecutionState)state.searchTypes().get((Object)st.id());
                return st.applyExecutionContext(executionState);
            }
            return st;
        }).collect(Collectors.toSet());
    }

    public static Query emptyRoot() {
        return Query.builder().id("").timerange(EmptyTimeRange.emptyTimeRange()).query(ElasticsearchQueryString.empty()).filter(null).build();
    }

    public Set<String> usedStreamIds() {
        return Optional.ofNullable(this.filter()).map(optFilter -> {
            Traverser filterTraverser = Traverser.forTree(filter -> (Iterable)MoreObjects.firstNonNull(filter.filters(), Collections.emptySet()));
            return StreamSupport.stream(filterTraverser.breadthFirst(optFilter).spliterator(), false).filter(filter -> filter instanceof StreamFilter).map(streamFilter -> ((StreamFilter)streamFilter).streamId()).filter(Objects::nonNull).collect(Collectors.toSet());
        }).orElse(Collections.emptySet());
    }

    public Set<String> streamIdsForPermissionsCheck() {
        Set searchTypeStreamIds = this.searchTypes().stream().map(SearchType::streams).reduce(Collections.emptySet(), Sets::union);
        return Sets.union(this.usedStreamIds(), (Set)searchTypeStreamIds);
    }

    public boolean hasStreams() {
        return !this.usedStreamIds().isEmpty();
    }

    public boolean hasReferencedStreamFilters() {
        return this.filters() != null && this.filters().stream().anyMatch(f -> f instanceof ReferencedSearchFilter);
    }

    public Query addStreamsToFilter(Set<String> streamIds) {
        Filter newFilter = this.addStreamsTo(this.filter(), streamIds);
        return this.toBuilder().filter(newFilter).build();
    }

    private Filter addStreamsTo(Filter filter, Set<String> streamIds) {
        Filter streamIdFilter = StreamFilter.anyIdOf(streamIds.toArray(new String[0]));
        if (filter == null) {
            return streamIdFilter;
        }
        return AndFilter.and(streamIdFilter, filter);
    }

    public boolean hasSearchType(String searchTypeId) {
        return this.searchTypes().stream().map(SearchType::id).anyMatch(id -> id.equals(searchTypeId));
    }

    private Filter shallowMappedFilter(EntityDescriptorIds entityDescriptorIds) {
        return Optional.ofNullable(this.filter()).map(optFilter -> {
            Set<Filter> newFilters = optFilter.filters().stream().map(filter -> {
                if (filter.type().equals("stream")) {
                    StreamFilter streamFilter = (StreamFilter)filter;
                    String streamId = entityDescriptorIds.getOrThrow(streamFilter.streamId(), ModelTypes.STREAM_V1);
                    return streamFilter.toBuilder().streamId(streamId).build();
                }
                return filter;
            }).collect(Collectors.toSet());
            return optFilter.toGenericBuilder().filters(newFilters).build();
        }).orElse(null);
    }

    @Override
    public QueryEntity toContentPackEntity(EntityDescriptorIds entityDescriptorIds) {
        return QueryEntity.builder().searchTypes(this.searchTypes().stream().map(s -> (SearchTypeEntity)s.toContentPackEntity(entityDescriptorIds)).collect(Collectors.toSet())).filter(this.shallowMappedFilter(entityDescriptorIds)).filters(this.filters()).query(this.query()).id(this.id()).globalOverride(this.globalOverride().orElse(null)).timerange(this.timerange()).build();
    }

    @JsonPOJOBuilder(withPrefix="")
    @AutoValue.Builder
    public static abstract class Builder {
        @JsonProperty
        public abstract Builder id(String var1);

        public abstract String id();

        @JsonProperty
        public abstract Builder timerange(TimeRange var1);

        @JsonProperty
        public abstract Builder filter(Filter var1);

        @JsonProperty
        public abstract Builder filters(List<UsedSearchFilter> var1);

        @JsonProperty
        public abstract Builder query(BackendQuery var1);

        public abstract Builder globalOverride(@Nullable GlobalOverride var1);

        @JsonProperty(value="search_types")
        public abstract Builder searchTypes(@Nullable Set<SearchType> var1);

        abstract Query autoBuild();

        @JsonCreator
        static Builder createWithDefaults() {
            try {
                return new AutoValue_Query.Builder().searchTypes((Set<SearchType>)ImmutableSortedSet.of()).filters(Collections.emptyList()).query(ElasticsearchQueryString.empty()).timerange(RelativeRange.create(300));
            }
            catch (InvalidRangeParametersException e) {
                throw new RuntimeException("Unable to create relative timerange - this should not happen!");
            }
        }

        public Query build() {
            if (this.id() == null) {
                this.id(UUID.randomUUID().toString());
            }
            return this.autoBuild();
        }
    }
}

